/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.state;

import com.tc.l2.context.StateChangedEvent;
import com.tc.l2.msg.L2StateMessage;
import com.tc.l2.state.ServerMode;
import com.tc.l2.state.StateChangeListener;
import com.tc.net.NodeID;
import com.tc.net.ServerID;
import com.tc.net.groups.GroupException;
import com.tc.text.PrettyPrintable;
import com.tc.util.State;
import java.util.Set;

public interface StateManager
extends PrettyPrintable {
    public static final State ACTIVE_COORDINATOR = new State("ACTIVE-COORDINATOR");
    public static final State RECOVERING_STATE = new State("RECOVERING");
    public static final State PASSIVE_UNINITIALIZED = new State("PASSIVE-UNINITIALIZED");
    public static final State PASSIVE_SYNCING = new State("PASSIVE-SYNCING");
    public static final State PASSIVE_STANDBY = new State("PASSIVE-STANDBY");
    public static final State START_STATE = new State("START-STATE");
    public static final State STOP_STATE = new State("STOP-STATE");
    public static final State DIAGNOSTIC_STATE = new State("DIAGNOSTIC");
    public static final State BOOTSTRAP_STATE = new State("BOOTSTRAP");

    public void initializeAndStartElection();

    public ServerMode getCurrentMode();

    public void startElectionIfNecessary(NodeID var1);

    public void registerForStateChangeEvents(StateChangeListener var1);

    public void fireStateChangedEvent(StateChangedEvent var1);

    public boolean isActiveCoordinator();

    public void moveToPassiveSyncing(NodeID var1);

    public void moveToPassiveStandbyState();

    public void moveToStopState();

    public void moveToDiagnosticMode();

    public boolean moveToStopStateIf(Set<ServerMode> var1);

    public void publishActiveState(NodeID var1) throws GroupException;

    public void handleClusterStateMessage(L2StateMessage var1);

    public NodeID getActiveNodeID();

    public Set<ServerID> getPassiveStandbys();

    public void shutdown();

    public static ServerMode convert(State state) {
        if (state == null) {
            return ServerMode.START;
        }
        return ServerMode.VALID_STATES.stream().filter(m -> m.getState().equals((Object)state)).findFirst().get();
    }
}

