/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.state;

import com.tc.l2.state.ServerVoterManager;
import com.tc.management.AbstractTerracottaMBean;
import com.tc.management.TerracottaManagement;
import com.tc.services.TimeSource;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.server.ServerEnv;

public class ServerVoterManagerImpl
extends AbstractTerracottaMBean
implements ServerVoterManager {
    private static final Logger logger = LoggerFactory.getLogger(ServerVoterManagerImpl.class);
    static final long VOTEBEAT_TIMEOUT = 5000L;
    private final Supplier<Integer> voterLimit;
    final Map<String, Long> voters = new ConcurrentHashMap<String, Long>();
    private final TimeSource timeSource;
    private volatile boolean votingInProgress = false;
    private volatile long electionTerm;
    private final Set<String> votes = ConcurrentHashMap.newKeySet();
    private volatile boolean overrideVote = false;

    public ServerVoterManagerImpl(Supplier<Integer> voterLimit) throws Exception {
        this(voterLimit, TimeSource.SYSTEM_TIME_SOURCE, true);
    }

    ServerVoterManagerImpl(Supplier<Integer> voterLimit, TimeSource timeSource, boolean initMBean) throws Exception {
        super(ServerVoterManager.class, false);
        if (initMBean) {
            try {
                ServerEnv.getServer().getManagement().getMBeanServer().registerMBean(this, TerracottaManagement.createObjectName(null, (String)"VoterManager", (TerracottaManagement.MBeanDomain)TerracottaManagement.MBeanDomain.PUBLIC));
            }
            catch (Exception e) {
                logger.warn("problem registering MBean", (Throwable)e);
            }
        }
        this.voterLimit = voterLimit;
        this.timeSource = timeSource;
        this.electionTerm = 0L;
    }

    public synchronized long registerVoter(String id) {
        if (this.voters.containsKey(id)) {
            return 0L;
        }
        if (!this.canAcceptVoter()) {
            logger.info("Voter id: " + id + " could not be registered as there is no voter vacancy available");
            return -1L;
        }
        this.voters.put(id, this.timeSource.currentTimeMillis());
        logger.info("Registration of voter id: " + id + " confirmed.");
        return this.electionTerm;
    }

    boolean canAcceptVoter() {
        return !this.votingInProgress && this.getRegisteredVoters() < this.voterLimit.get();
    }

    public long heartbeat(String id) {
        logger.debug("received heartbeat {}", (Object)id);
        Long val = this.voters.computeIfPresent(id, (key, timeStamp) -> {
            long currentTime = this.timeSource.currentTimeMillis();
            if (currentTime - timeStamp < 5000L) {
                return currentTime;
            }
            this.votes.remove(key);
            this.voters.remove(key);
            return null;
        });
        if (val == null) {
            return -1L;
        }
        if (this.votingInProgress) {
            return this.electionTerm;
        }
        return 0L;
    }

    @Override
    public void startVoting(long electionTerm, boolean cancelOverride) {
        this.electionTerm = electionTerm;
        this.votes.clear();
        if (cancelOverride) {
            this.overrideVote = false;
        }
        this.votingInProgress = true;
    }

    public long vote(String id, long electionTerm) {
        long response = this.heartbeat(id);
        if (response > 0L && electionTerm == this.electionTerm) {
            this.votes.add(id);
            return 0L;
        }
        return response;
    }

    public long vote(String idTerm) {
        String[] split = idTerm.split(":");
        return this.vote(split[0], Long.parseLong(split[1]));
    }

    @Override
    public int getRegisteredVoters() {
        return (int)this.voters.entrySet().stream().filter(entry -> {
            if (this.timeSource.currentTimeMillis() - (Long)entry.getValue() < 5000L) {
                return true;
            }
            String id = (String)entry.getKey();
            this.votes.remove(id);
            this.voters.remove(id);
            return false;
        }).count();
    }

    @Override
    public int getVoteCount() {
        if (this.overrideVote) {
            return Integer.MAX_VALUE;
        }
        return this.votes.size();
    }

    @Override
    public int getVoterLimit() {
        return this.voterLimit.get();
    }

    public boolean overrideVote(String id) {
        logger.info("Override vote received from {}", (Object)id);
        this.overrideVote = true;
        return true;
    }

    @Override
    public boolean overrideVoteReceived() {
        return this.overrideVote;
    }

    @Override
    public long stopVoting() {
        this.votingInProgress = false;
        return this.electionTerm;
    }

    public boolean deregisterVoter(String id) {
        logger.info("Deregister " + id);
        return !this.votingInProgress ? this.voters.remove(id) != null : false;
    }

    public void reset() {
    }
}

