/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.state;

import com.tc.l2.state.StateManager;
import com.tc.util.State;
import java.util.EnumSet;
import java.util.Set;

public enum ServerMode {
    INITIAL(StateManager.BOOTSTRAP_STATE){

        @Override
        public boolean containsData() {
            return false;
        }

        @Override
        public boolean canBeActive() {
            return true;
        }

        @Override
        public boolean isStartup() {
            return true;
        }
    }
    ,
    START(StateManager.START_STATE){

        @Override
        public boolean containsData() {
            return false;
        }

        @Override
        public boolean canBeActive() {
            return true;
        }

        @Override
        public boolean isStartup() {
            return true;
        }
    }
    ,
    UNINITIALIZED(StateManager.PASSIVE_UNINITIALIZED){

        @Override
        public boolean containsData() {
            return false;
        }
    }
    ,
    RECOVERING(StateManager.RECOVERING_STATE),
    SYNCING(StateManager.PASSIVE_SYNCING),
    PASSIVE(StateManager.PASSIVE_STANDBY){

        @Override
        public boolean canBeActive() {
            return true;
        }

        @Override
        public boolean canStartElection() {
            return true;
        }
    }
    ,
    ACTIVE(StateManager.ACTIVE_COORDINATOR){

        @Override
        public boolean canBeActive() {
            return true;
        }
    }
    ,
    STOP(StateManager.STOP_STATE),
    DIAGNOSTIC(StateManager.DIAGNOSTIC_STATE);

    private final State name;
    public static final Set<ServerMode> VALID_STATES;
    public static final Set<ServerMode> PASSIVE_STATES;

    private ServerMode(State name) {
        this.name = name;
    }

    public State getState() {
        return this.name;
    }

    public String toString() {
        return this.name.toString();
    }

    public String getName() {
        return this.name.getName();
    }

    public boolean equals() {
        throw new AssertionError();
    }

    public boolean canBeActive() {
        return false;
    }

    public boolean containsData() {
        return true;
    }

    public boolean isStartup() {
        return false;
    }

    public boolean canStartElection() {
        return this.isStartup();
    }

    static {
        VALID_STATES = EnumSet.allOf(ServerMode.class);
        PASSIVE_STATES = EnumSet.of(UNINITIALIZED, PASSIVE, SYNCING);
    }
}

