/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.state;

import com.tc.l2.ha.WeightGeneratorFactory;
import com.tc.l2.state.ConsistencyMBeanImpl;
import com.tc.l2.state.ConsistencyManager;
import com.tc.l2.state.Enrollment;
import com.tc.l2.state.ServerMode;
import com.tc.logging.TCLogging;
import com.tc.management.TerracottaManagement;
import com.tc.net.NodeID;
import com.tc.net.groups.GroupEventsListener;
import com.tc.objectserver.impl.Topology;
import com.tc.util.concurrent.SetOnceFlag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.server.ServerEnv;

public class SafeStartupManagerImpl
implements ConsistencyManager,
GroupEventsListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SafeStartupManagerImpl.class);
    private static final Logger CONSOLE = TCLogging.getConsoleLogger();
    private final boolean consistentStartup;
    private boolean allowTransition = false;
    private boolean suspended = false;
    private final int peerServers;
    private final ConsistencyManager consistencyManager;
    private final Set<NodeID> activePeers = new HashSet<NodeID>();
    private final SetOnceFlag disable = new SetOnceFlag();

    public SafeStartupManagerImpl(boolean consistentStartup, int peerServers, ConsistencyManager consistencyManager) {
        this.consistentStartup = consistentStartup;
        this.peerServers = peerServers;
        this.consistencyManager = consistencyManager;
        this.initMBean();
    }

    public Map<String, ?> getStateMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("type", "SafeStartup");
        map.put("allowTransition", this.allowTransition);
        map.put("suspended", this.suspended);
        map.put("peerServers", new ArrayList(this.peerServers).stream().map(n -> n.toString()).collect(Collectors.toList()));
        map.put("disable", this.disable.isSet());
        map.put("delegate", this.consistencyManager.getStateMap());
        return map;
    }

    private void initMBean() {
        try {
            ObjectName mbeanName = TerracottaManagement.createObjectName(null, (String)"ConsistencyManager", (TerracottaManagement.MBeanDomain)TerracottaManagement.MBeanDomain.PUBLIC);
            ServerEnv.getServer().getManagement().getMBeanServer().registerMBean(new ConsistencyMBeanImpl(this), mbeanName);
        }
        catch (Exception e) {
            LOGGER.warn("SafeMode MBean not initialized", (Throwable)e);
        }
    }

    @Override
    public boolean requestTransition(ServerMode mode, NodeID sourceNode, Topology topology, ConsistencyManager.Transition newMode) throws IllegalStateException {
        if (this.safeTransition(mode, sourceNode, topology, newMode)) {
            return this.consistencyManager.requestTransition(mode, sourceNode, topology, newMode);
        }
        return false;
    }

    private synchronized boolean safeTransition(ServerMode mode, NodeID sourceNode, Topology topology, ConsistencyManager.Transition newMode) throws IllegalStateException {
        if (newMode == ConsistencyManager.Transition.CONNECT_TO_ACTIVE) {
            this.disable.attemptSet();
            this.suspended = false;
        } else if (!this.disable.isSet() && this.consistentStartup && mode.isStartup() && newMode == ConsistencyManager.Transition.MOVE_TO_ACTIVE) {
            if (this.activePeers.size() == this.peerServers) {
                CONSOLE.info("Action:{} allowed because all servers are connected", (Object)newMode);
                this.suspended = false;
            } else if (this.allowTransition) {
                CONSOLE.info("Action:{} allowed with external intervention", (Object)newMode);
                this.suspended = false;
            } else {
                CONSOLE.info("Action:{} not allowed because not enough servers are connected", (Object)newMode);
                this.suspended = true;
            }
        } else {
            this.suspended = false;
        }
        return !this.suspended;
    }

    @Override
    public synchronized boolean lastTransitionSuspended() {
        if (this.suspended) {
            return true;
        }
        return this.consistencyManager.lastTransitionSuspended();
    }

    @Override
    public synchronized void allowLastTransition() {
        if (this.suspended) {
            LOGGER.info("External intervention to allow the last requested transition");
            this.allowTransition = true;
        } else {
            this.consistencyManager.allowLastTransition();
        }
    }

    @Override
    public Collection<ConsistencyManager.Transition> requestedActions() {
        return this.consistencyManager.requestedActions();
    }

    @Override
    public void nodeJoined(NodeID nodeID) {
        this.activePeers.add(nodeID);
        if (this.consistencyManager instanceof GroupEventsListener) {
            ((GroupEventsListener)((Object)this.consistencyManager)).nodeJoined(nodeID);
        }
    }

    @Override
    public void nodeLeft(NodeID nodeID) {
        this.activePeers.remove(nodeID);
        if (this.consistencyManager instanceof GroupEventsListener) {
            ((GroupEventsListener)((Object)this.consistencyManager)).nodeLeft(nodeID);
        }
    }

    @Override
    public long getCurrentTerm() {
        return this.consistencyManager.getCurrentTerm();
    }

    @Override
    public void setCurrentTerm(long term) {
        this.consistencyManager.setCurrentTerm(term);
    }

    @Override
    public Enrollment createVerificationEnrollment(NodeID lastActive, WeightGeneratorFactory weightFactory) {
        return this.consistencyManager.createVerificationEnrollment(lastActive, weightFactory);
    }
}

