/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.state;

import com.tc.async.api.AbstractEventHandler;
import com.tc.async.api.EventHandler;
import com.tc.async.api.EventHandlerException;
import com.tc.l2.ha.WeightGeneratorFactory;
import com.tc.l2.msg.L2StateMessage;
import com.tc.l2.state.ElectionContext;
import com.tc.l2.state.ElectionManager;
import com.tc.l2.state.Enrollment;
import com.tc.l2.state.EnrollmentFactory;
import com.tc.l2.state.ServerMode;
import com.tc.l2.state.StateManager;
import com.tc.net.NodeID;
import com.tc.net.ServerID;
import com.tc.net.groups.GroupEventsListener;
import com.tc.net.groups.GroupException;
import com.tc.net.groups.GroupManager;
import com.tc.net.groups.GroupResponse;
import com.tc.net.utils.L2Utils;
import com.tc.util.Assert;
import com.tc.util.State;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElectionManagerImpl
implements ElectionManager {
    private static final Logger logger = LoggerFactory.getLogger(ElectionManagerImpl.class);
    private static final State INIT = new State("Initial-State");
    private static final State ELECTION_COMPLETE = new State("Election-Complete");
    private static final State ELECTION_VOTED = new State("Election-Votes-Are-In");
    private static final State ELECTION_IN_PROGRESS = new State("Election-In-Progress");
    private final GroupManager<L2StateMessage> groupManager;
    private final Map<NodeID, Enrollment> votes = new HashMap<NodeID, Enrollment>();
    private State state = INIT;
    private Enrollment myVote = null;
    private State serverState;
    private Enrollment winner;
    private NodeID active = ServerID.NULL_ID;
    private Set<ServerID> passiveStandbys;
    private final long electionTime;
    private int expectedServers;

    public ElectionManagerImpl(GroupManager groupManager, int electionTimeInSec) {
        this.groupManager = groupManager;
        this.electionTime = electionTimeInSec * 1000;
        this.groupManager.registerForGroupEvents(new GroupEventsListener(){

            @Override
            public void nodeJoined(NodeID nodeID) {
                ElectionManagerImpl.this.sendToNewMember(nodeID);
            }

            @Override
            public void nodeLeft(NodeID nodeID) {
                ElectionManagerImpl.debugInfo("node left " + nodeID);
            }
        });
    }

    public synchronized void shutdown() {
        this.state = INIT;
        this.notifyAll();
    }

    public EventHandler<ElectionContext> getEventHandler() {
        return new AbstractEventHandler<ElectionContext>(){

            public void handleEvent(ElectionContext context) throws EventHandlerException {
                context.setWinner(ElectionManagerImpl.this.runElection(context.getNode(), context.getServers(), context.isNew(), context.getFactory(), context.getCurrentState()));
            }

            public void destroy() {
                super.destroy();
                ElectionManagerImpl.this.reset((NodeID)ServerID.NULL_ID, null);
            }
        };
    }

    public Set<ServerID> passiveStandbys() {
        return this.passiveStandbys;
    }

    @Override
    public synchronized boolean handleStartElectionRequest(L2StateMessage msg, State currentState) {
        Assert.assertEquals((int)0, (int)msg.getType());
        if (this.state == ELECTION_IN_PROGRESS) {
            Enrollment vote = msg.getEnrollment();
            Enrollment old = this.votes.put(vote.getNodeID(), vote);
            if (this.votes.size() == this.expectedServers) {
                this.state = ELECTION_VOTED;
                this.notify();
            }
            if (this.myVote.isANewCandidate() || !msg.getEnrollment().isANewCandidate()) {
                boolean sendResponse = msg.inResponseTo().isNull();
                if (old != null && !vote.equals((Object)old)) {
                    logger.warn("Received duplicate vote : Replacing with new one : " + vote + " old one : " + old);
                    sendResponse = true;
                }
                if (sendResponse) {
                    L2StateMessage response = L2StateMessage.createElectionStartedMessage((L2StateMessage)msg, (Enrollment)this.myVote, (State)currentState);
                    logger.info("Cast vote from " + msg + " My Response : " + response);
                    try {
                        this.groupManager.sendTo((NodeID)msg.messageFrom(), response);
                    }
                    catch (GroupException e) {
                        logger.error("Error sending Votes to : " + msg.messageFrom(), (Throwable)e);
                    }
                } else {
                    logger.info("Cast vote from " + msg);
                }
                return true;
            }
        }
        logger.info("Ignoring Start Election Request  : " + msg + " My state = " + this.state + " " + this.myVote);
        return false;
    }

    @Override
    public synchronized void handleElectionAbort(L2StateMessage msg, State currentState) {
        Assert.assertEquals((int)4, (int)msg.getType());
        ElectionManagerImpl.debugInfo("Handling election abort");
        if (this.state == ELECTION_IN_PROGRESS) {
            Assert.assertNotNull((Object)this.myVote);
            this.basicAbort(msg);
        } else {
            logger.warn("Ignoring Abort Election Request  : " + msg + " My state = " + this.state);
        }
    }

    @Override
    public synchronized void handleElectionResultMessage(L2StateMessage msg, State currentState) {
        Assert.assertEquals((int)1, (int)msg.getType());
        ElectionManagerImpl.debugInfo("Handling election result");
        if (this.state == ELECTION_COMPLETE && !this.winner.equals((Object)msg.getEnrollment())) {
            L2StateMessage resultConflict = L2StateMessage.createResultConflictMessage((L2StateMessage)msg, (Enrollment)this.winner, (State)currentState);
            logger.warn("WARNING :: Election result conflict : Winner local = " + this.winner + " :  remote winner = " + msg.getEnrollment());
            try {
                this.groupManager.sendTo((NodeID)msg.messageFrom(), resultConflict);
            }
            catch (GroupException e) {
                logger.error("Error sending Election result conflict message : " + resultConflict);
            }
        } else {
            if (this.state == ELECTION_IN_PROGRESS) {
                this.basicAbort(msg);
            }
            L2StateMessage resultAgreed = L2StateMessage.createResultAgreedMessage((L2StateMessage)msg, (Enrollment)msg.getEnrollment(), (State)currentState);
            logger.info("Agreed with Election Result from " + msg.messageFrom() + " : " + resultAgreed);
            try {
                this.groupManager.sendTo((NodeID)msg.messageFrom(), resultAgreed);
            }
            catch (GroupException e) {
                logger.error("Error sending Election result agreed message : " + resultAgreed);
            }
        }
    }

    private void basicAbort(L2StateMessage msg) {
        this.reset((NodeID)msg.messageFrom(), msg.getEnrollment());
        logger.info("Aborted Election : Winner is : " + this.winner);
    }

    @Override
    public synchronized void declareWinner(Enrollment verify, State currentState) {
        L2StateMessage msg = L2StateMessage.createElectionWonMessage((Enrollment)verify, (State)currentState);
        ElectionManagerImpl.debugInfo("Announcing as winner: " + this.groupManager.getLocalNodeID());
        this.groupManager.sendAll(msg);
        logger.info("Declared as Winner: Winner is : " + this.winner);
        this.reset((NodeID)this.groupManager.getLocalNodeID(), this.winner);
    }

    @Override
    public synchronized void reset(NodeID winnerNode, Enrollment winningEnrollment) {
        this.active = winnerNode;
        this.winner = winningEnrollment;
        this.state = INIT;
        this.votes.clear();
        this.myVote = null;
        this.notifyAll();
    }

    private NodeID runElection(NodeID myNodeId, Set<String> servers, boolean isNew, WeightGeneratorFactory weightsFactory, State currentState) {
        ServerID winnerID = ServerID.NULL_ID;
        int count = 0;
        while (winnerID.isNull()) {
            if (count++ > 0) {
                logger.info("Requesting Re-election !!! count = " + count);
            }
            try {
                winnerID = this.doElection(myNodeId, servers, isNew, weightsFactory, currentState);
            }
            catch (InterruptedException e) {
                L2Utils.handleInterrupted(logger, e);
                this.reset((NodeID)ServerID.NULL_ID, null);
                return ServerID.NULL_ID;
            }
            catch (GroupException e1) {
                logger.error("Error during election : ", (Throwable)e1);
                this.reset((NodeID)ServerID.NULL_ID, null);
            }
        }
        return winnerID;
    }

    private synchronized void sendToNewMember(NodeID node) {
        if (this.state == ELECTION_IN_PROGRESS) {
            L2StateMessage msg = L2StateMessage.createElectionStartedMessage((Enrollment)this.myVote, (State)this.serverState);
            ElectionManagerImpl.debugInfo("Sending my election vote to a new member " + node);
            try {
                this.groupManager.sendTo(node, msg);
            }
            catch (GroupException ge) {
                logger.error("Error during election : ", (Throwable)ge);
            }
        } else {
            ElectionManagerImpl.debugInfo("no election in progress not sending to " + node);
        }
    }

    private synchronized void electionStarted(Enrollment e, State serverState, int expectedServers) {
        if (this.state == ELECTION_IN_PROGRESS) {
            throw new AssertionError((Object)"Election Already in Progress");
        }
        this.state = ELECTION_IN_PROGRESS;
        this.expectedServers = expectedServers;
        this.myVote = e;
        this.serverState = serverState;
        this.winner = null;
        this.passiveStandbys = null;
        this.votes.clear();
        this.votes.put(e.getNodeID(), e);
        logger.info("Election Started : " + e);
    }

    private NodeID doElection(NodeID myNodeId, Set<String> servers, boolean isNew, WeightGeneratorFactory weightsFactory, State currentState) throws GroupException, InterruptedException {
        Enrollment e = EnrollmentFactory.createEnrollment(myNodeId, isNew, weightsFactory);
        this.electionStarted(e, currentState, servers.size());
        L2StateMessage msg = L2StateMessage.createElectionStartedMessage((Enrollment)e, (State)currentState);
        ElectionManagerImpl.debugInfo("Sending my election vote to all members");
        this.groupManager.sendTo(servers, msg);
        long waited = this.waitTillElectionComplete();
        Assert.assertTrue((waited <= 0L || this.state == ELECTION_VOTED || this.state == INIT ? 1 : 0) != 0);
        logger.info("Election took " + TimeUnit.MILLISECONDS.toSeconds(this.electionTime - waited) + " sec. ending in " + this.state);
        Enrollment lWinner = this.computeResult();
        if (lWinner == null) {
            return ServerID.NULL_ID;
        }
        if (lWinner != e) {
            logger.info("Election lost : Winner is : " + lWinner);
            Assert.assertNotNull((Object)lWinner);
            return this.active;
        }
        msg = L2StateMessage.createElectionResultMessage((Enrollment)e, (State)currentState);
        ElectionManagerImpl.debugInfo("Won election, announcing to world and waiting for response...");
        GroupResponse<L2StateMessage> responses = this.groupManager.sendToAndWaitForResponse(servers, msg);
        HashSet<ServerID> passives = new HashSet<ServerID>();
        for (L2StateMessage response : responses.getResponses()) {
            Assert.assertEquals((Object)msg.getMessageID(), (Object)response.inResponseTo());
            if (response.getType() == 2) {
                Assert.assertEquals((Object)e, (Object)response.getEnrollment());
                if (StateManager.convert(response.getState()) != ServerMode.PASSIVE) continue;
                passives.add(response.messageFrom());
                continue;
            }
            if (response.getType() == 3) {
                logger.info("Result Conflict: Local Result : " + e + " From : " + response.messageFrom() + " Result : " + response.getEnrollment());
                return ServerID.NULL_ID;
            }
            throw new AssertionError((Object)("Node : " + response.messageFrom() + " responded neither with RESULT_AGREED or RESULT_CONFLICT :" + response));
        }
        this.passiveStandbys = Collections.unmodifiableSet(passives);
        return myNodeId;
    }

    private synchronized Enrollment computeResult() {
        if (this.state == ELECTION_IN_PROGRESS || this.state == ELECTION_VOTED) {
            this.state = ELECTION_COMPLETE;
            logger.info("Election Complete : " + this.votes.values() + " : " + this.state);
            this.winner = this.countVotes();
            this.active = this.winner.getNodeID();
        }
        return this.winner;
    }

    private Enrollment countVotes() {
        Enrollment computedWinner = null;
        for (Enrollment e : this.votes.values()) {
            if (computedWinner == null) {
                computedWinner = e;
                continue;
            }
            if (!e.wins(computedWinner)) continue;
            computedWinner = e;
        }
        Assert.assertNotNull(computedWinner);
        return computedWinner;
    }

    private synchronized long waitTillElectionComplete() throws InterruptedException {
        long diff;
        long start;
        ElectionManagerImpl.debugInfo("Waiting till election complete, electionTime=" + this.electionTime);
        for (diff = this.electionTime; this.state == ELECTION_IN_PROGRESS && diff > 0L; diff -= System.currentTimeMillis() - start) {
            start = System.currentTimeMillis();
            this.wait(diff);
        }
        return diff;
    }

    @Override
    public long getElectionTime() {
        return this.electionTime;
    }

    private static void debugInfo(String message) {
        logger.debug(message);
    }
}

