/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.state;

import com.tc.l2.ha.WeightGeneratorFactory;
import com.tc.l2.state.ConsistencyManager;
import com.tc.l2.state.Enrollment;
import com.tc.l2.state.EnrollmentFactory;
import com.tc.l2.state.ServerMode;
import com.tc.l2.state.ServerVoterManager;
import com.tc.l2.state.ServerVoterManagerImpl;
import com.tc.logging.TCLogging;
import com.tc.net.NodeID;
import com.tc.net.ServerID;
import com.tc.net.groups.GroupEventsListener;
import com.tc.net.utils.L2Utils;
import com.tc.objectserver.impl.Topology;
import com.tc.objectserver.impl.TopologyManager;
import com.tc.util.Assert;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistencyManagerImpl
implements ConsistencyManager,
GroupEventsListener {
    private static final Logger CONSOLE = TCLogging.getConsoleLogger();
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsistencyManagerImpl.class);
    private final TopologyManager topologyManager;
    private boolean activeVote = false;
    private boolean blocked = false;
    private Set<ConsistencyManager.Transition> actions = EnumSet.noneOf(ConsistencyManager.Transition.class);
    private long voteTerm = 1L;
    private long blockedAt = Long.MAX_VALUE;
    private final ServerVoterManager voter;
    private final Set<NodeID> activePeers = Collections.synchronizedSet(new HashSet());
    private final Set<NodeID> passives = Collections.synchronizedSet(new HashSet());

    public Map<String, ?> getStateMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("type", "Consistency");
        map.put("peerServers", this.topologyManager.getTopology().getServers().size() - 1);
        map.put("activeVote", this.activeVote);
        map.put("blocked", this.blocked);
        map.put("actions", new HashSet<ConsistencyManager.Transition>(this.actions).stream().map(Enum::toString).collect(Collectors.toList()));
        map.put("votingTerm", this.voteTerm);
        map.put("blockedAt", this.blockedAt);
        map.put("activePeers", new ArrayList<NodeID>(this.activePeers).stream().map(n -> n.toString()).collect(Collectors.toList()));
        map.put("passives", new ArrayList<NodeID>(this.passives).stream().map(n -> n.toString()).collect(Collectors.toList()));
        LinkedHashMap<String, Constable> voteMap = new LinkedHashMap<String, Constable>();
        voteMap.put("registered", Integer.valueOf(this.voter.getRegisteredVoters()));
        voteMap.put("count", Integer.valueOf(this.voter.getVoteCount()));
        voteMap.put("limit", Integer.valueOf(this.topologyManager.getExternalVoters()));
        voteMap.put("overridden", Boolean.valueOf(this.voter.overrideVoteReceived()));
        map.put("voter", voteMap);
        return map;
    }

    public ConsistencyManagerImpl(TopologyManager topologyManager) {
        this.topologyManager = topologyManager;
        try {
            this.voter = new ServerVoterManagerImpl(topologyManager::getExternalVoters);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized long getBlockingTimestamp() {
        return this.blockedAt;
    }

    @Override
    public void nodeJoined(NodeID nodeID) {
        this.activePeers.add(nodeID);
    }

    @Override
    public void nodeLeft(NodeID nodeID) {
        this.activePeers.remove(nodeID);
    }

    @Override
    public long getCurrentTerm() {
        return this.voteTerm;
    }

    @Override
    public void setCurrentTerm(long term) {
        this.voteTerm = term;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requestTransition(ServerMode mode, NodeID sourceNode, Topology topology, ConsistencyManager.Transition newMode) throws IllegalStateException {
        int peerServers;
        int serverVotes;
        boolean allow;
        block15: {
            int threshold;
            if (topology == null) {
                topology = this.topologyManager.getTopology();
            }
            if (this.topologyManager.isAvailability()) {
                return true;
            }
            if (newMode == ConsistencyManager.Transition.ADD_PASSIVE) {
                this.passives.add(sourceNode);
                Assert.assertEquals((Object)((Object)mode), (Object)((Object)ServerMode.ACTIVE));
                CONSOLE.info("Action:{} is always allowed", (Object)newMode);
                return true;
            }
            if (newMode == ConsistencyManager.Transition.CONNECT_TO_ACTIVE) {
                this.endVoting(true, newMode, topology);
                CONSOLE.info("Action:{} is always allowed", (Object)newMode);
                return true;
            }
            if (newMode == ConsistencyManager.Transition.REMOVE_PASSIVE) {
                this.passives.remove(sourceNode);
                Assert.assertEquals((Object)((Object)mode), (Object)((Object)ServerMode.ACTIVE));
            }
            if (!newMode.isStateTransition()) {
                return !this.isBlocked();
            }
            allow = false;
            serverVotes = this.activateVoting(mode, newMode, topology);
            if (serverVotes >= (threshold = this.voteThreshold(mode, peerServers = topology.getServers().size() - 1)) || serverVotes == peerServers) {
                CONSOLE.info("Action:{} allowed because enough servers are connected", (Object)newMode);
                this.endVoting(true, newMode, topology);
                return true;
            }
            if (this.voter.overrideVoteReceived()) {
                CONSOLE.info("Action:{} allowed because override received", (Object)newMode);
                this.endVoting(true, newMode, topology);
                return true;
            }
            long start = System.currentTimeMillis();
            try {
                if (this.voter.getRegisteredVoters() + serverVotes < threshold) {
                    CONSOLE.warn("Not enough registered voters.  Require override intervention or {} members of the stripe to be connected for action {}", peerServers + 1 > threshold ? Integer.valueOf(threshold) : "all", (Object)newMode);
                    break block15;
                }
                while (!allow && System.currentTimeMillis() - start < 5000L) {
                    try {
                        if (serverVotes + this.voter.getVoteCount() < threshold) {
                            TimeUnit.MILLISECONDS.sleep(100L);
                            continue;
                        }
                        allow = true;
                    }
                    catch (InterruptedException ie) {
                        L2Utils.handleInterrupted(LOGGER, ie);
                    }
                }
            }
            catch (Throwable throwable) {
                CONSOLE.info("Action:{} granted:{} vote tally servers:{} external:{} of total:{}", new Object[]{newMode, allow, serverVotes + 1, this.voter.getVoteCount(), peerServers + this.topologyManager.getExternalVoters() + 1});
                this.endVoting(allow, newMode, topology);
                throw throwable;
            }
        }
        CONSOLE.info("Action:{} granted:{} vote tally servers:{} external:{} of total:{}", new Object[]{newMode, allow, serverVotes + 1, this.voter.getVoteCount(), peerServers + this.topologyManager.getExternalVoters() + 1});
        this.endVoting(allow, newMode, topology);
        return allow;
    }

    @Override
    public boolean lastTransitionSuspended() {
        return this.blocked;
    }

    @Override
    public void allowLastTransition() {
        try {
            this.voter.overrideVote("external");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    @Override
    public Collection<ConsistencyManager.Transition> requestedActions() {
        return Collections.unmodifiableSet(this.actions);
    }

    private int voteThreshold(ServerMode mode, int peerServers) {
        int voteCount = peerServers + this.topologyManager.getExternalVoters() + 1;
        if (mode == ServerMode.ACTIVE) {
            return voteCount - (voteCount >> 1) - 1;
        }
        return voteCount >> 1;
    }

    private synchronized int activateVoting(ServerMode mode, ConsistencyManager.Transition moveTo, Topology topology) {
        if (!this.activeVote) {
            this.blocked = true;
            this.blockedAt = System.currentTimeMillis();
            this.activeVote = true;
            boolean stateTransition = moveTo.isStateTransition();
            if (stateTransition) {
                ++this.voteTerm;
            }
            this.voter.startVoting(this.voteTerm, stateTransition);
        }
        this.actions.add(moveTo);
        if (mode != ServerMode.ACTIVE || moveTo == ConsistencyManager.Transition.ZAP_NODE) {
            return ConsistencyManagerImpl.filterActivePeers(this.activePeers, topology).size();
        }
        return this.passives.size();
    }

    private void promotePeers(Set<NodeID> activePeers) {
        this.passives.addAll(activePeers);
    }

    private static Set<NodeID> filterActivePeers(Set<NodeID> activePeers, Topology topology) {
        return activePeers.stream().filter(p -> topology.getServers().contains(((ServerID)p).getName())).collect(Collectors.toSet());
    }

    private synchronized void endVoting(boolean allowed, ConsistencyManager.Transition moveTo, Topology topology) {
        Assert.assertTrue((boolean)moveTo.isStateTransition());
        if (this.activeVote && allowed) {
            switch (moveTo) {
                case MOVE_TO_ACTIVE: {
                    this.promotePeers(ConsistencyManagerImpl.filterActivePeers(this.activePeers, topology));
                }
                case CONNECT_TO_ACTIVE: {
                    this.actions.remove((Object)ConsistencyManager.Transition.CONNECT_TO_ACTIVE);
                    this.actions.remove((Object)ConsistencyManager.Transition.MOVE_TO_ACTIVE);
                    break;
                }
                default: {
                    this.actions.remove((Object)moveTo);
                }
            }
            if (this.actions.isEmpty()) {
                Assert.assertEquals((long)this.voteTerm, (long)this.voter.stopVoting());
                this.activeVote = false;
                this.blocked = false;
                this.blockedAt = Long.MAX_VALUE;
            }
        }
    }

    public synchronized Collection<ConsistencyManager.Transition> getActions() {
        return new ArrayList<ConsistencyManager.Transition>(this.actions);
    }

    public synchronized boolean isVoting() {
        return this.activeVote;
    }

    public synchronized boolean isBlocked() {
        return this.blocked;
    }

    @Override
    public Enrollment createVerificationEnrollment(NodeID lastActive, WeightGeneratorFactory weightFactory) {
        return EnrollmentFactory.createVerificationEnrollment(lastActive, weightFactory);
    }
}

