/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.state;

import com.tc.l2.ha.WeightGeneratorFactory;
import com.tc.l2.state.Enrollment;
import com.tc.l2.state.ServerMode;
import com.tc.logging.TCLogging;
import com.tc.net.NodeID;
import com.tc.objectserver.impl.Topology;
import com.tc.text.PrettyPrintable;
import java.util.Collection;
import org.slf4j.Logger;
import org.terracotta.configuration.FailoverBehavior;
import org.terracotta.server.ServerEnv;
import org.terracotta.server.StopAction;

public interface ConsistencyManager
extends PrettyPrintable {
    default public boolean requestTransition(ServerMode mode, NodeID sourceNode, Transition newMode) throws IllegalStateException {
        return this.requestTransition(mode, sourceNode, null, newMode);
    }

    public boolean requestTransition(ServerMode var1, NodeID var2, Topology var3, Transition var4) throws IllegalStateException;

    public boolean lastTransitionSuspended();

    public void allowLastTransition();

    public Collection<Transition> requestedActions();

    public long getCurrentTerm();

    public void setCurrentTerm(long var1);

    public Enrollment createVerificationEnrollment(NodeID var1, WeightGeneratorFactory var2);

    public static int parseVoteCount(FailoverBehavior priority, int serverCount) {
        Logger consoleLogger = TCLogging.getConsoleLogger();
        if (serverCount == 1) {
            return -1;
        }
        if (priority == null) {
            consoleLogger.error("*****************************************************************************");
            consoleLogger.error("* Failover priority is not specified and it is a mandatory configuration. *");
            consoleLogger.error("*****************************************************************************");
            ServerEnv.getServer().stop(new StopAction[0]);
            return -1;
        }
        if (priority.isAvailability()) {
            consoleLogger.info("Running the server in AVAILABILITY mode with the risk of split brain scenarios.");
            return -1;
        }
        try {
            consoleLogger.info("Running the server in CONSISTENCY mode with compromised availability of the cluster.");
            int voters = priority.getExternalVoters();
            if (voters < 0) {
                throw new IllegalArgumentException("the voter count cannot be negative");
            }
            return voters;
        }
        catch (NullPointerException npe) {
            return 0;
        }
    }

    public static enum Transition {
        MOVE_TO_ACTIVE,
        CONNECT_TO_ACTIVE,
        ADD_CLIENT{

            @Override
            boolean isStateTransition() {
                return false;
            }
        }
        ,
        REMOVE_PASSIVE,
        ADD_PASSIVE,
        ZAP_NODE{

            @Override
            boolean isStateTransition() {
                return false;
            }
        };


        boolean isStateTransition() {
            return true;
        }
    }
}

