/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.util.FileSize;
import com.tc.l2.logging.BufferingAppender;
import com.tc.l2.logging.StartupAndSizeBasedTriggeringPolicy;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.tripwire.EventAppender;

public class TCLogbackLogging {
    public static final String CONSOLE = "org.terracotta.console";
    public static final String STDOUT_APPENDER = "STDOUT";
    private static final String TC_PATTERN = "%d [%t] %p %c - %m%n";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"org.terracotta.console");

    public static void resetLogging() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        ch.qos.logback.classic.Logger root = loggerContext.getLogger("ROOT");
        ch.qos.logback.classic.Logger console = loggerContext.getLogger(CONSOLE);
        root.detachAndStopAllAppenders();
        console.detachAndStopAllAppenders();
        loggerContext.reset();
    }

    public static void setServerName(String name) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        String currentName = loggerContext.getName();
        if (currentName == null || currentName.equals("default")) {
            loggerContext.setName(name);
        } else if (!name.equals(currentName)) {
            throw new RuntimeException("server names do not match exsiting:" + loggerContext.getName() + " given:" + name);
        }
    }

    public static void bootstrapLogging(OutputStream out) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        ch.qos.logback.classic.Logger root = loggerContext.getLogger("ROOT");
        Iterator appenders = root.iteratorForAppenders();
        boolean hasBuffer = false;
        boolean hasJfr = false;
        while (appenders.hasNext()) {
            Appender check = (Appender)appenders.next();
            if (check instanceof BufferingAppender) {
                hasBuffer = true;
                if (out == null) continue;
                ((BufferingAppender)check).setOutputStream(out);
                continue;
            }
            if (!(check instanceof EventAppender)) continue;
            hasJfr = true;
        }
        if (!hasBuffer) {
            BufferingAppender appender = new BufferingAppender();
            appender.setName("TC_BASE");
            appender.setContext((Context)loggerContext);
            if (out != null) {
                appender.setOutputStream(out);
            }
            appender.start();
            root.addAppender((Appender)appender);
        }
        if (!hasJfr && EventAppender.isEnabled()) {
            EventAppender events = new EventAppender();
            events.setName("LogToJFR");
            events.setContext((Context)loggerContext);
            events.start();
            root.addAppender((Appender)events);
        }
        ch.qos.logback.classic.Logger silent = loggerContext.getLogger("org.terracotta.silent");
        silent.setAdditive(false);
        silent.setLevel(Level.OFF);
    }

    public static void redirectLogging(File logDirFile) {
        String logDir = TCLogbackLogging.getPathString(logDirFile);
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        ch.qos.logback.classic.Logger root = loggerContext.getLogger("ROOT");
        if (logDirFile != null) {
            Appender<ILoggingEvent> continuingAppender = TCLogbackLogging.installFileAppender(logDir, loggerContext);
            root.addAppender(continuingAppender);
            TCLogbackLogging.disableBufferingAppender(continuingAppender);
        } else {
            TCLogbackLogging.disableBufferingAppender(null);
        }
    }

    private static void disableBufferingAppender(Appender<ILoggingEvent> continuingAppender) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        ch.qos.logback.classic.Logger root = loggerContext.getLogger("ROOT");
        ch.qos.logback.classic.Logger console = loggerContext.getLogger(CONSOLE);
        Iterator appenders = root.iteratorForAppenders();
        if (appenders != null) {
            while (appenders.hasNext()) {
                Appender current = (Appender)appenders.next();
                if (!(current instanceof BufferingAppender)) continue;
                if (continuingAppender != null) {
                    root.detachAppender(current);
                    ((BufferingAppender)current).sendContentsTo(arg_0 -> continuingAppender.doAppend(arg_0));
                    root.addAppender(continuingAppender);
                    console.addAppender(current);
                    continue;
                }
                ((BufferingAppender)current).sendContentsTo(e -> {});
            }
        }
    }

    private static Appender<ILoggingEvent> installFileAppender(String logDir, LoggerContext loggerContext) {
        String logLocation = logDir + File.separator + "terracotta.server.log";
        LOGGER.info("Log file: {}", (Object)logLocation);
        RollingFileAppender fileAppender = new RollingFileAppender();
        fileAppender.setName("ROLLING");
        fileAppender.setContext((Context)loggerContext);
        fileAppender.setFile(logLocation);
        PatternLayoutEncoder logEncoder = new PatternLayoutEncoder();
        logEncoder.setContext((Context)loggerContext);
        logEncoder.setPattern(TC_PATTERN);
        logEncoder.start();
        fileAppender.setEncoder((Encoder)logEncoder);
        FixedWindowRollingPolicy rollingPolicy = new FixedWindowRollingPolicy();
        rollingPolicy.setMinIndex(1);
        rollingPolicy.setMaxIndex(20);
        rollingPolicy.setFileNamePattern(logDir + File.separator + "terracotta.server.%i.log");
        rollingPolicy.setContext((Context)loggerContext);
        rollingPolicy.setParent((FileAppender)fileAppender);
        rollingPolicy.start();
        fileAppender.setRollingPolicy((RollingPolicy)rollingPolicy);
        StartupAndSizeBasedTriggeringPolicy triggeringPolicy = new StartupAndSizeBasedTriggeringPolicy();
        triggeringPolicy.setMaxFileSize(FileSize.valueOf((String)"512MB"));
        triggeringPolicy.setContext((Context)loggerContext);
        triggeringPolicy.start();
        fileAppender.setTriggeringPolicy(triggeringPolicy);
        fileAppender.start();
        return fileAppender;
    }

    private static String getPathString(File logPath) {
        if (logPath == null) {
            LOGGER.info("Logging directory is not set. Logging only to the console");
            return null;
        }
        if (!logPath.exists()) {
            if (!logPath.mkdirs()) {
                throw new RuntimeException("Failed to created logging directory " + logPath);
            }
            LOGGER.info("Created logging directory {}", (Object)logPath);
        } else if (!logPath.isDirectory()) {
            throw new RuntimeException("Logging path " + logPath + " is not a directory");
        }
        try {
            return logPath.getCanonicalPath();
        }
        catch (IOException ioe) {
            throw new UncheckedIOException("Error getting canonical path for the logging directory", ioe);
        }
    }
}

