/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.logging;

import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.joran.spi.ConsoleTarget;
import ch.qos.logback.core.spi.ContextAware;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;

public class BufferingAppender
extends OutputStreamAppender<ILoggingEvent> {
    private final Queue<ILoggingEvent> buffer = new ConcurrentLinkedQueue<ILoggingEvent>();
    private boolean bufferLogs = true;

    public BufferingAppender() {
        this.setName("STDOUT");
        this.setImmediateFlush(true);
    }

    public void start() {
        if (this.getEncoder() == null) {
            PatternLayoutEncoder defaultEncoder = new PatternLayoutEncoder();
            defaultEncoder.setPattern("%d %p - %m%n");
            defaultEncoder.setParent((ContextAware)this);
            defaultEncoder.setContext(this.context);
            defaultEncoder.start();
            this.setEncoder((Encoder)defaultEncoder);
        }
        if (this.getOutputStream() == null) {
            this.setOutputStream(ConsoleTarget.SystemOut.getStream());
        }
        super.start();
    }

    public void setContext(Context context) {
        super.setContext(context);
    }

    protected void append(ILoggingEvent eventObject) {
        if (this.bufferLogs) {
            while (this.buffer.size() > 4096) {
                this.buffer.poll();
            }
            this.buffer.add(eventObject);
        } else {
            this.drainBuffer(null);
            super.append((Object)eventObject);
        }
    }

    private void drainBuffer(Consumer<ILoggingEvent> other) {
        ILoggingEvent event;
        while ((event = this.buffer.poll()) != null) {
            super.append((Object)event);
            if (other == null) continue;
            other.accept(event);
        }
    }

    public void sendContentsTo(Consumer<ILoggingEvent> otherAppender) {
        this.drainBuffer(otherAppender);
        this.bufferLogs = false;
    }
}

