/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.ha;

import com.tc.util.Assert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class WeightGeneratorFactory {
    private final List<WeightGenerator> generators;
    private final boolean complete;

    public WeightGeneratorFactory() {
        this.generators = new ArrayList<WeightGenerator>();
        this.complete = false;
    }

    private WeightGeneratorFactory(List<WeightGenerator> generators) {
        this.generators = Collections.unmodifiableList(generators);
        this.complete = true;
    }

    public void add(WeightGenerator g) {
        Assert.assertNotNull((Object)g);
        this.generators.add(g);
    }

    public WeightGeneratorFactory complete() {
        return new WeightGeneratorFactory(this.generators);
    }

    public boolean isComplete() {
        return this.complete;
    }

    public long[] generateWeightSequence() {
        Assert.assertTrue((boolean)this.isComplete());
        long[] weights = new long[this.generators.size()];
        for (int i = 0; i < weights.length; ++i) {
            weights[i] = this.generators.get(i).getWeight();
        }
        return weights;
    }

    public long[] generateMaxWeightSequence() {
        Assert.assertTrue((boolean)this.isComplete());
        long[] weights = new long[this.generators.size()];
        for (int i = 0; i < weights.length; ++i) {
            weights[i] = Long.MAX_VALUE;
        }
        return weights;
    }

    public long[] generateVerificationSequence() {
        Assert.assertTrue((boolean)this.isComplete());
        long[] weights = new long[this.generators.size()];
        for (int i = 0; i < this.generators.size(); ++i) {
            WeightGenerator gen = this.generators.get(i);
            weights[i] = gen.isVerificationWeight() ? gen.getWeight() : Long.MAX_VALUE;
        }
        return weights;
    }

    public int size() {
        Assert.assertTrue((boolean)this.isComplete());
        return this.generators.size();
    }

    public static interface WeightGenerator {
        public long getWeight();

        default public boolean isVerificationWeight() {
            return false;
        }
    }
}

