/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.ha;

import com.tc.net.StripeID;
import com.tc.net.groups.StripeIDEventListener;
import com.tc.net.groups.StripeIDStateManager;
import com.tc.objectserver.persistence.ClusterStatePersistor;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StripeIDStateManagerImpl
implements StripeIDStateManager {
    private static final Logger logger = LoggerFactory.getLogger(StripeIDStateManagerImpl.class);
    private final CopyOnWriteArrayList<StripeIDEventListener> listeners = new CopyOnWriteArrayList();
    private StripeID stripeID = StripeID.NULL_ID;
    private final AtomicInteger unKnownIDCount = new AtomicInteger(0);
    private final ClusterStatePersistor clusterStatePersistor;

    public StripeIDStateManagerImpl(ClusterStatePersistor clusterStatePersistor) {
        this.clusterStatePersistor = clusterStatePersistor;
        this.unKnownIDCount.set(this.loadStripeIDFromDB());
    }

    private int loadStripeIDFromDB() {
        this.stripeID = this.clusterStatePersistor.getStripeID();
        return this.stripeID.isNull() ? 1 : 0;
    }

    @Override
    public StripeID getStripeID() {
        return this.stripeID;
    }

    @Override
    public boolean isStripeIDMatched(StripeID stripeID) {
        return !stripeID.isNull() && stripeID.equals((Object)this.getStripeID());
    }

    private void putToStore(StripeID stripeID) {
        logger.info("Persisting StripeID - " + stripeID);
        this.clusterStatePersistor.setStripeID(stripeID);
    }

    @Override
    public boolean verifyOrSaveStripeID(StripeID newID, boolean overwrite) {
        if (newID.isNull()) {
            logger.warn("Ignore null StripeID");
            return false;
        }
        StripeID oldID = this.stripeID;
        if (overwrite || oldID.isNull()) {
            this.putToStore(newID);
            if (oldID.isNull()) {
                this.unKnownIDCount.decrementAndGet();
            }
            logger.debug("Collected " + newID + " count: " + this.unKnownIDCount.get());
            this.stripeID = newID;
            this.notifyLocalStripeIDReady(newID);
        } else if (!oldID.equals((Object)this.stripeID)) {
            logger.error("Mismatch StripeID " + oldID + " with " + this.stripeID);
            return false;
        }
        return true;
    }

    private void notifyLocalStripeIDReady(StripeID stripeID) {
        for (StripeIDEventListener listener : this.listeners) {
            listener.notifyStripeIDCreated(stripeID);
        }
    }

    @Override
    public void registerForStripeIDEvents(StripeIDEventListener listener) {
        this.listeners.add(listener);
        StripeID stripeID = this.getStripeID();
        if (!stripeID.isNull()) {
            listener.notifyStripeIDCreated(stripeID);
        }
        if (this.unKnownIDCount.get() == 0) {
            listener.notifyStripeIDMapReady();
        }
    }
}

