/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.ha;

import com.tc.l2.api.ReplicatedClusterStateManager;
import com.tc.l2.ha.ClusterState;
import com.tc.l2.msg.ClusterStateMessage;
import com.tc.l2.state.ServerMode;
import com.tc.logging.TCLogging;
import com.tc.net.NodeID;
import com.tc.net.groups.AbstractGroupMessage;
import com.tc.net.groups.GroupException;
import com.tc.net.groups.GroupManager;
import com.tc.net.groups.GroupMessageListener;
import com.tc.net.groups.GroupResponse;
import com.tc.net.protocol.transport.ConnectionID;
import com.tc.net.utils.L2Utils;
import com.tc.util.Assert;
import com.tc.util.State;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.configuration.ConfigurationProvider;

public class ReplicatedClusterStateManagerImpl
implements ReplicatedClusterStateManager,
GroupMessageListener<ClusterStateMessage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReplicatedClusterStateManagerImpl.class);
    private final GroupManager<AbstractGroupMessage> groupManager;
    private final ClusterState state;
    private final ConfigurationProvider configurationProvider;
    private final Supplier<ServerMode> currentMode;
    private boolean isActive = false;
    private final Collection<NodeID> others = new HashSet<NodeID>();

    public ReplicatedClusterStateManagerImpl(GroupManager<AbstractGroupMessage> groupManager, Supplier<ServerMode> currentMode, ClusterState clusterState, ConfigurationProvider configurationProvider) {
        this.groupManager = groupManager;
        this.currentMode = currentMode;
        this.state = clusterState;
        this.configurationProvider = configurationProvider;
        groupManager.registerForMessages(ClusterStateMessage.class, this);
    }

    @Override
    public synchronized void goActiveAndSyncState() {
        switch (this.currentMode.get()) {
            case ACTIVE: {
                this.state.setCurrentState(this.currentMode.get().getState());
                this.state.generateStripeIDIfNeeded();
                this.state.syncActiveState();
                this.others.clear();
                this.state.setConfigSyncData(this.configurationProvider.getSyncData());
                this.others.addAll(this.publishToAll((AbstractGroupMessage)ClusterStateMessage.createClusterStateMessage((ClusterState)this.state)));
                this.isActive = true;
                break;
            }
            case STOP: {
                TCLogging.getConsoleLogger().warn("Failed to activate.  Server is stopping");
                break;
            }
            default: {
                throw new AssertionError((Object)("cannot activate. State:" + (Object)((Object)this.currentMode.get())));
            }
        }
        this.notifyAll();
    }

    @Override
    public synchronized void publishClusterState(NodeID nodeID) throws GroupException {
        this.waitUntilActive();
        this.state.setConfigSyncData(this.configurationProvider.getSyncData());
        ClusterStateMessage msg = (ClusterStateMessage)this.groupManager.sendToAndWaitForResponse(nodeID, (AbstractGroupMessage)ClusterStateMessage.createClusterStateMessage((ClusterState)this.state));
        this.validateResponse(nodeID, msg);
    }

    private void waitUntilActive() {
        while (!this.isActive) {
            LOGGER.info("Waiting since ReplicatedClusterStateManager hasn't gone ACTIVE yet ...");
            try {
                this.wait(3000L);
            }
            catch (InterruptedException e) {
                L2Utils.handleInterrupted(LOGGER, e);
            }
        }
    }

    private boolean validateResponse(NodeID nodeID, ClusterStateMessage msg) {
        if (msg == null || msg.getType() != 255) {
            LOGGER.error("Recd wrong response from : " + nodeID + " : msg = " + msg + " while publishing Cluster State");
            return false;
        }
        return true;
    }

    public synchronized void connectionIDCreated(ConnectionID connectionID) {
        Assert.assertTrue((boolean)this.isActive);
        this.state.addNewConnection(connectionID);
        Collection<NodeID> sentTo = this.publishToAll((AbstractGroupMessage)ClusterStateMessage.createNewConnectionCreatedMessage((ConnectionID)connectionID));
        LOGGER.debug("applied to " + sentTo);
    }

    public synchronized void connectionIDDestroyed(ConnectionID connectionID) {
        Assert.assertTrue((boolean)this.isActive);
        this.state.removeConnection(connectionID);
        Collection<NodeID> sentTo = this.publishToAll((AbstractGroupMessage)ClusterStateMessage.createConnectionDestroyedMessage((ConnectionID)connectionID));
        LOGGER.debug("applied to " + sentTo);
    }

    private Collection<NodeID> publishToAll(AbstractGroupMessage message) {
        try {
            GroupResponse<AbstractGroupMessage> gr = this.groupManager.sendAllAndWaitForResponse(message);
            HashSet<NodeID> success = new HashSet<NodeID>();
            for (AbstractGroupMessage resp : gr.getResponses()) {
                ClusterStateMessage msg = (ClusterStateMessage)resp;
                if (this.validateResponse((NodeID)msg.messageFrom(), msg)) {
                    success.add((NodeID)msg.messageFrom());
                    continue;
                }
                LOGGER.info("message not validated {} by {} result {}", new Object[]{message, msg.messageFrom(), msg.getType()});
            }
            return success;
        }
        catch (GroupException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void messageReceived(NodeID fromNode, ClusterStateMessage msg) {
        this.handleClusterStateMessage(fromNode, msg);
    }

    private void handleClusterStateMessage(NodeID fromNode, ClusterStateMessage msg) {
        if (this.isActive) {
            LOGGER.warn("Recd ClusterStateMessage from " + fromNode + " while I am the cluster co-ordinator. This is bad. Sending NG response. ");
            this.sendNGSplitBrainResponse(fromNode, msg);
        } else {
            if (msg.isSplitBrainMessage()) {
                return;
            }
            if (ServerMode.PASSIVE_STATES.contains((Object)this.currentMode.get())) {
                msg.initState(this.state);
                if (msg.getType() == 240) {
                    this.configurationProvider.sync(this.state.getConfigSyncData());
                }
                this.state.syncSequenceState();
                this.sendOKResponse(fromNode, msg);
            } else {
                this.sendNGSplitBrainResponse(fromNode, msg);
            }
        }
    }

    private void sendOKResponse(NodeID fromNode, ClusterStateMessage msg) {
        try {
            this.groupManager.sendTo(fromNode, (AbstractGroupMessage)ClusterStateMessage.createOKResponse((ClusterStateMessage)msg));
        }
        catch (GroupException e) {
            LOGGER.error("Error handling message : " + msg, (Throwable)e);
        }
    }

    private void sendNGSplitBrainResponse(NodeID fromNode, ClusterStateMessage msg) {
        try {
            this.groupManager.sendTo(fromNode, (AbstractGroupMessage)ClusterStateMessage.createNGSplitBrainResponse((ClusterStateMessage)msg));
        }
        catch (GroupException e) {
            LOGGER.error("Error handling message : " + msg, (Throwable)e);
        }
    }

    @Override
    public synchronized void setCurrentState(State currentState) {
        this.state.setCurrentState(currentState);
    }

    @Override
    public void reportStateToMap(Map<String, Object> state) {
        state.put("className", this.getClass().getName());
        LinkedHashMap cstate = new LinkedHashMap();
        state.put("state", cstate);
        this.state.reportStateToMap(cstate);
        state.put("currentMode", this.currentMode.get().toString());
    }
}

