/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.ha;

import com.tc.exception.TCShutdownServerException;
import com.tc.exception.ZapDirtyDbServerNodeException;
import com.tc.exception.ZapServerNodeException;
import com.tc.l2.ha.WeightGeneratorFactory;
import com.tc.l2.state.ConsistencyManager;
import com.tc.l2.state.Enrollment;
import com.tc.l2.state.StateManager;
import com.tc.net.NodeID;
import com.tc.net.groups.GroupManager;
import com.tc.net.groups.ZapEventListener;
import com.tc.net.groups.ZapNodeRequestProcessor;
import com.tc.objectserver.persistence.ClusterStatePersistor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class L2HAZapNodeRequestProcessor
implements ZapNodeRequestProcessor {
    private static final Logger logger = LoggerFactory.getLogger(L2HAZapNodeRequestProcessor.class);
    public static final int COMMUNICATION_ERROR = 1;
    public static final int PROGRAM_ERROR = 2;
    public static final int NODE_JOINED_WITH_DIRTY_DB = 3;
    public static final int COMMUNICATION_TO_ACTIVE_ERROR = 4;
    public static final int PARTIALLY_SYNCED_PASSIVE_JOINED = 5;
    public static final int INSUFFICIENT_RESOURCES = 6;
    public static final int SPLIT_BRAIN = 255;
    private final Logger consoleLogger;
    private final StateManager stateManager;
    private final WeightGeneratorFactory factory;
    private final GroupManager groupManager;
    private final List<ZapEventListener> listeners = new CopyOnWriteArrayList<ZapEventListener>();
    private final ClusterStatePersistor clusterStatePersistor;
    private final ConsistencyManager consistencyMgr;

    public L2HAZapNodeRequestProcessor(Logger consoleLogger, StateManager stateManager, GroupManager groupManager, WeightGeneratorFactory factory, ClusterStatePersistor clusterStatePersistor, ConsistencyManager consistency) {
        this.consoleLogger = consoleLogger;
        this.stateManager = stateManager;
        this.groupManager = groupManager;
        this.factory = factory;
        this.clusterStatePersistor = clusterStatePersistor;
        this.consistencyMgr = consistency;
    }

    @Override
    public boolean acceptOutgoingZapNodeRequest(NodeID nodeID, int zapNodeType, String reason) {
        this.assertOnType(zapNodeType, reason);
        if (zapNodeType == 4 && nodeID.equals(this.stateManager.getActiveNodeID())) {
            this.consoleLogger.warn("Requesting active node to quit : " + this.getFormatedError(nodeID, zapNodeType));
            return true;
        }
        if (this.stateManager.isActiveCoordinator()) {
            if (this.consistencyMgr.requestTransition(this.stateManager.getCurrentMode(), nodeID, ConsistencyManager.Transition.ZAP_NODE)) {
                this.consoleLogger.warn("Requesting node to quit : " + this.getFormatedError(nodeID, zapNodeType));
                return true;
            }
            logger.warn("Not allowing to Zap " + nodeID + " since server does not have consistency votes");
            return false;
        }
        logger.warn("Not allowing to Zap " + nodeID + " since not in " + StateManager.ACTIVE_COORDINATOR);
        return false;
    }

    @Override
    public long[] getCurrentNodeWeights() {
        return this.factory.generateWeightSequence();
    }

    private String getFormatedError(NodeID nodeID, int zapNodeType) {
        return this.getFormatedError(nodeID, zapNodeType, null);
    }

    private String getFormatedError(NodeID nodeID, int zapNodeType, String reason) {
        return "NodeID : " + nodeID + " Error Type : " + this.getErrorTypeString(zapNodeType) + (reason != null ? " Details : " + reason : "");
    }

    private String getErrorTypeString(int type) {
        switch (type) {
            case 1: {
                return "COMMUNICATION ERROR";
            }
            case 4: {
                return "COMMUNICATION TO ACTIVE SERVER ERROR";
            }
            case 2: {
                return "PROGRAM ERROR";
            }
            case 3: {
                return "Newly Joined Node Contains dirty database.";
            }
            case 5: {
                return "Newly joined node in uninitialized state is already partially synced - this is not supported.";
            }
            case 255: {
                return "Two or more Active servers detected in the cluster";
            }
            case 6: {
                return "L2 has insufficient resources to join the cluster. Check dataStorage and offheap settings and try again.";
            }
        }
        throw new AssertionError((Object)("Unknown type : " + type));
    }

    private void assertOnType(int type, String reason) {
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 255: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown type : " + type + " reason : " + reason));
            }
        }
    }

    @Override
    public void incomingZapNodeRequest(NodeID nodeID, int zapNodeType, String reason, long[] weights) {
        this.assertOnType(zapNodeType, reason);
        if (this.stateManager.isActiveCoordinator()) {
            logger.warn(StateManager.ACTIVE_COORDINATOR + " received Zap Node request from another " + StateManager.ACTIVE_COORDINATOR + "\n" + this.getFormatedError(nodeID, zapNodeType, reason));
            this.handleSplitBrainScenario(nodeID, zapNodeType, reason, weights);
        } else {
            NodeID activeNode = this.stateManager.getActiveNodeID();
            if (activeNode.isNull() || activeNode.equals(nodeID)) {
                String message = "Terminating due to Zap request from " + this.getFormatedError(nodeID, zapNodeType, reason);
                logger.error(message);
                if (zapNodeType == 3) {
                    this.clusterStatePersistor.setDBClean(false);
                    throw new ZapDirtyDbServerNodeException(message);
                }
                if (zapNodeType == 6) {
                    throw new TCShutdownServerException(message);
                }
                throw new ZapServerNodeException(message);
            }
            logger.warn("Ignoring Zap Node since it did not come from " + StateManager.ACTIVE_COORDINATOR + " " + activeNode + " but from " + this.getFormatedError(nodeID, zapNodeType, reason));
        }
    }

    private void handleSplitBrainScenario(NodeID nodeID, int zapNodeType, String reason, long[] weights) {
        long[] myWeights = this.factory.generateWeightSequence();
        logger.warn("A Terracotta server tried to join the mirror group as a second ACTIVE : My weights = " + this.toString(myWeights) + " Other servers weights = " + this.toString(weights));
        for (ZapEventListener listener : this.listeners) {
            listener.fireSplitBrainEvent((NodeID)this.groupManager.getLocalNodeID(), nodeID);
        }
        Enrollment hisOrHers = new Enrollment(nodeID, false, weights);
        Enrollment mine = new Enrollment((NodeID)this.groupManager.getLocalNodeID(), false, myWeights);
        if (hisOrHers.wins(mine)) {
            logger.warn(nodeID + " wins : Backing off : Exiting !!!");
            String message = "Found that " + nodeID + " is active and has more clients connected to it than this server. Exiting ... !!";
            for (ZapEventListener listener : this.listeners) {
                listener.fireBackOffEvent(nodeID);
            }
            throw new ZapServerNodeException(message);
        }
        logger.warn("Not quiting since the other servers weight = " + this.toString(weights) + " is not greater than my weight = " + this.toString(myWeights));
        this.consoleLogger.warn("Ignoring Quit request from " + nodeID + " since remote servers weight is not greater than local weight");
    }

    private String toString(long[] l) {
        if (l == null) {
            return "null";
        }
        if (l.length == 0) {
            return "empty";
        }
        StringBuffer sb = new StringBuffer();
        for (long element : l) {
            sb.append(String.valueOf(element)).append(",");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public static String getErrorString(Throwable t) {
        StringWriter sw = new StringWriter();
        sw.write("\nException : ");
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        sw.write("\n");
        return sw.toString();
    }

    @Override
    public void addZapEventListener(ZapEventListener listener) {
        this.listeners.add(listener);
    }
}

