/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.ha;

import com.tc.l2.api.L2Coordinator;
import com.tc.l2.api.ReplicatedClusterStateManager;
import com.tc.l2.ha.ClusterStateImpl;
import com.tc.l2.ha.L2HAZapNodeRequestProcessor;
import com.tc.l2.ha.ReplicatedClusterStateManagerImpl;
import com.tc.l2.ha.WeightGeneratorFactory;
import com.tc.l2.state.ConsistencyManager;
import com.tc.l2.state.StateManager;
import com.tc.net.NodeID;
import com.tc.net.groups.AbstractGroupMessage;
import com.tc.net.groups.GroupException;
import com.tc.net.groups.GroupManager;
import com.tc.net.groups.StripeIDStateManager;
import com.tc.net.protocol.transport.ConnectionID;
import com.tc.net.protocol.transport.ConnectionIDFactoryListener;
import com.tc.objectserver.impl.DistributedObjectServer;
import com.tc.objectserver.persistence.Persistor;
import com.tc.util.Assert;
import com.tc.util.State;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class L2HACoordinator
implements L2Coordinator,
ConnectionIDFactoryListener {
    private static final Logger logger = LoggerFactory.getLogger(L2HACoordinator.class);
    private final Logger consoleLogger;
    private final DistributedObjectServer server;
    private final GroupManager<AbstractGroupMessage> groupManager;
    private final StateManager stateManager;
    private ReplicatedClusterStateManager rClusterStateMgr;

    public L2HACoordinator(Logger consoleLogger, DistributedObjectServer server, StateManager stateManager, GroupManager<AbstractGroupMessage> groupCommsManager, Persistor persistor, WeightGeneratorFactory weightGeneratorFactory, StripeIDStateManager stripeIDStateManager, ConsistencyManager consistencyMgr) {
        this.consoleLogger = consoleLogger;
        this.server = server;
        this.groupManager = groupCommsManager;
        this.stateManager = stateManager;
        this.init(persistor, weightGeneratorFactory, stripeIDStateManager, consistencyMgr);
    }

    private void init(Persistor persistor, WeightGeneratorFactory weightGeneratorFactory, StripeIDStateManager stripeIDStateManager, ConsistencyManager consistencyMgr) {
        ClusterStateImpl clusterState = new ClusterStateImpl(persistor, this.server.getConnectionIdFactory(), stripeIDStateManager);
        L2HAZapNodeRequestProcessor zapProcessor = new L2HAZapNodeRequestProcessor(this.consoleLogger, this.stateManager, this.groupManager, weightGeneratorFactory, persistor.getClusterStatePersistor(), consistencyMgr);
        this.groupManager.setZapNodeRequestProcessor(zapProcessor);
        this.rClusterStateMgr = new ReplicatedClusterStateManagerImpl(this.groupManager, this.stateManager::getCurrentMode, clusterState, this.server.getConfigSetupManager().getConfigurationProvider());
        this.server.getConnectionIdFactory().registerForConnectionIDEvents((ConnectionIDFactoryListener)this);
    }

    public void connectionIDCreated(ConnectionID connectionID) {
        this.getReplicatedClusterStateManager().connectionIDCreated(connectionID);
    }

    public void connectionIDDestroyed(ConnectionID connectionID) {
        this.getReplicatedClusterStateManager().connectionIDDestroyed(connectionID);
    }

    @Override
    public void start() {
        this.stateManager.initializeAndStartElection();
    }

    @Override
    public void shutdown() {
        this.stateManager.shutdown();
        this.shutdownReplicatedClusterStateManager();
    }

    @Override
    public StateManager getStateManager() {
        return this.stateManager;
    }

    private synchronized void shutdownReplicatedClusterStateManager() {
        this.rClusterStateMgr = new ReplicatedClusterStateManager(){

            @Override
            public void goActiveAndSyncState() {
            }

            @Override
            public void publishClusterState(NodeID nodeID) throws GroupException {
            }

            @Override
            public void setCurrentState(State currentState) {
            }

            @Override
            public void reportStateToMap(Map<String, Object> state) {
                state.put("type", "NOOP");
                state.put("state", "SHUTDOWN");
            }

            public void connectionIDCreated(ConnectionID connectionID) {
            }

            public void connectionIDDestroyed(ConnectionID connectionID) {
            }
        };
    }

    @Override
    public synchronized ReplicatedClusterStateManager getReplicatedClusterStateManager() {
        return this.rClusterStateMgr;
    }

    @Override
    public GroupManager<AbstractGroupMessage> getGroupManager() {
        return this.groupManager;
    }

    @Override
    public void nodeJoined(NodeID nodeID) {
        this.log(nodeID + " joined the cluster");
        if (this.stateManager.isActiveCoordinator()) {
            try {
                this.stateManager.publishActiveState(nodeID);
            }
            catch (GroupException ge) {
                String errMesg = "A Terracotta server tried to join the mirror group as a second ACTIVE: " + nodeID + " Zapping it to allow it to join as PASSIVE standby (backup): ";
                logger.error(errMesg, (Throwable)ge);
                this.groupManager.zapNode(nodeID, 1, errMesg + L2HAZapNodeRequestProcessor.getErrorString(ge));
            }
        }
    }

    private void log(String message) {
        logger.info(message);
        this.consoleLogger.info(message);
    }

    private void warn(String message) {
        logger.warn(message);
        this.consoleLogger.warn(message);
    }

    @Override
    public void nodeLeft(NodeID nodeID) {
        this.warn(nodeID + " left the cluster");
        if (this.stateManager.isActiveCoordinator()) {
            Assert.assertFalse((nodeID.getNodeType() == 1 ? 1 : 0) != 0);
        } else {
            this.stateManager.startElectionIfNecessary(nodeID);
        }
    }

    public Map<String, ?> getStateMap() {
        if (this.rClusterStateMgr != null) {
            LinkedHashMap<String, Object> state = new LinkedHashMap<String, Object>();
            this.rClusterStateMgr.reportStateToMap(state);
            state.put("stateManager", this.stateManager.getStateMap());
            return state;
        }
        return Collections.emptyMap();
    }
}

