/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.ha;

import com.tc.l2.ha.ClusterIDMissmatchException;
import com.tc.l2.ha.ClusterState;
import com.tc.net.StripeID;
import com.tc.net.groups.StripeIDStateManager;
import com.tc.net.protocol.transport.ConnectionID;
import com.tc.net.protocol.transport.ConnectionIDFactory;
import com.tc.objectserver.api.ClientNotFoundException;
import com.tc.objectserver.persistence.Persistor;
import com.tc.util.State;
import com.tc.util.UUID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterStateImpl
implements ClusterState {
    private static final Logger logger = LoggerFactory.getLogger(ClusterState.class);
    private final Persistor persistor;
    private final ConnectionIDFactory connectionIdFactory;
    private final StripeIDStateManager stripeIDStateManager;
    private final Set<ConnectionID> connections = Collections.synchronizedSet(new HashSet());
    private long nextAvailChannelID = -1L;
    private volatile long globalMessageID = -1L;
    private volatile State currentState;
    private byte[] configSyncData = new byte[0];

    public ClusterStateImpl(Persistor persistor, ConnectionIDFactory connectionIdFactory, StripeIDStateManager stripeIDStateManager) {
        this.persistor = persistor;
        this.connectionIdFactory = connectionIdFactory;
        this.stripeIDStateManager = stripeIDStateManager;
        this.nextAvailChannelID = this.connectionIdFactory.getCurrentConnectionID();
    }

    public synchronized long getNextAvailableChannelID() {
        return this.nextAvailChannelID;
    }

    public long getStartGlobalMessageID() {
        return this.globalMessageID;
    }

    public void setStartGlobalMessageID(long id) {
        this.globalMessageID = id;
    }

    public synchronized void setNextAvailableChannelID(long nextAvailableCID) {
        if (nextAvailableCID < this.nextAvailChannelID) {
            logger.error("Trying to set Next Available ChannelID to a lesser value : known = " + this.nextAvailChannelID + " new value = " + nextAvailableCID + " IGNORING");
            return;
        }
        logger.info("setting next available cid: {}", (Object)nextAvailableCID);
        this.nextAvailChannelID = nextAvailableCID;
        this.persistor.getClientStatePersistor().getConnectionIDSequence().setNext(this.nextAvailChannelID);
    }

    public void syncActiveState() {
        long nextId = this.getNextAvailableChannelID() + 1L;
        this.setNextAvailableChannelID(nextId);
        this.connectionIdFactory.activate(this.stripeIDStateManager.getStripeID(), nextId);
    }

    public void syncSequenceState() {
    }

    public StripeID getStripeID() {
        return this.stripeIDStateManager.getStripeID();
    }

    private boolean isStripeIDNull() {
        return this.stripeIDStateManager.getStripeID().isNull();
    }

    public void setStripeID(String uid) {
        if (!this.isStripeIDNull() && !this.stripeIDStateManager.getStripeID().getName().equals(uid)) {
            logger.error("StripeID doesnt match !! Mine : " + this.stripeIDStateManager.getStripeID() + " Active sent clusterID as : " + uid);
            throw new ClusterIDMissmatchException(this.stripeIDStateManager.getStripeID().getName(), uid);
        }
        this.stripeIDStateManager.verifyOrSaveStripeID(new StripeID(uid), true);
    }

    public void setCurrentState(State state) {
        this.currentState = state;
        this.syncCurrentStateToDB();
    }

    private void syncCurrentStateToDB() {
        this.persistor.getClusterStatePersistor().setCurrentL2State(this.currentState);
    }

    public void addNewConnection(ConnectionID connID) {
        if (connID.getChannelID() >= this.getNextAvailableChannelID()) {
            long cid = connID.getChannelID() + 1L;
            this.setNextAvailableChannelID(cid);
        }
        this.connections.add(connID);
        logger.info("connection added {}", (Object)connID);
        if (connID.getProductId().isReconnectEnabled()) {
            this.persistor.addClientState(connID.getClientID(), connID.getProductId());
        }
    }

    public void removeConnection(ConnectionID connectionID) {
        boolean removed = this.connections.remove(connectionID);
        if (!removed) {
            logger.debug("Connection ID not found, must be a failed reconnect : " + connectionID + " Current Connections count : " + this.connections.size());
        } else {
            logger.info("connection removed {}", (Object)connectionID);
        }
        try {
            if (connectionID.getProductId().isReconnectEnabled()) {
                this.persistor.removeClientState(connectionID.getClientID());
            }
        }
        catch (ClientNotFoundException notfound) {
            logger.debug("not found", (Throwable)notfound);
        }
    }

    public Set<ConnectionID> getAllConnections() {
        return new HashSet<ConnectionID>(this.connections);
    }

    public void generateStripeIDIfNeeded() {
        if (this.isStripeIDNull()) {
            this.setStripeID(UUID.getUUID().toString());
        }
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("ClusterState [ ");
        strBuilder.append("Connections [ ").append(this.connections).append(" ]");
        strBuilder.append(" nextAvailChannelID: ").append(this.nextAvailChannelID);
        strBuilder.append(" currentState: ").append(this.currentState);
        strBuilder.append(" stripeID: ").append(this.stripeIDStateManager.getStripeID());
        strBuilder.append(" ]");
        return strBuilder.toString();
    }

    public void reportStateToMap(Map<String, Object> state) {
        ArrayList connects = new ArrayList(this.connections.size());
        this.connections.forEach(c -> connects.add(c.toString()));
        state.put("connections", this.getAllConnections());
        state.put("nextChannelID", this.getNextAvailableChannelID());
        state.put("currentState", this.currentState);
        state.put("stripeID", this.stripeIDStateManager.getStripeID());
    }

    public byte[] getConfigSyncData() {
        return this.configSyncData;
    }

    public void setConfigSyncData(byte[] configSyncData) {
        this.configSyncData = configSyncData;
    }
}

