/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2;

import com.tc.objectserver.impl.ThisServerNodeId;
import com.tc.properties.TCPropertiesImpl;
import org.slf4j.Logger;

public abstract class L2DebugLogging {
    private static final String L2_DEBUG_LOGGING_PROP_NAME = "l2.debug-logging";
    private static final boolean ENABLED = TCPropertiesImpl.getProperties().getBoolean("l2.debug-logging", false);

    public static boolean isDebugLogging() {
        return ENABLED;
    }

    public static void log(Logger log, LogLevel level, String message, Throwable throwable) {
        if (!ENABLED) {
            return;
        }
        message = "[" + ThisServerNodeId.getThisServerNodeId() + "] " + message;
        switch (level) {
            case ERROR: {
                if (throwable != null) {
                    log.error(message, throwable);
                    break;
                }
                log.error(message);
                break;
            }
            case WARN: {
                if (throwable != null) {
                    log.warn(message, throwable);
                    break;
                }
                log.warn(message);
                break;
            }
            case INFO: {
                if (throwable != null) {
                    log.info(message, throwable);
                    break;
                }
                log.info(message);
                break;
            }
            case DEBUG: {
                if (throwable != null) {
                    log.debug(message, throwable);
                    break;
                }
                log.debug(message);
                break;
            }
            default: {
                if (throwable != null) {
                    log.error(message, throwable);
                    break;
                }
                log.error(message);
            }
        }
    }

    public static enum LogLevel {
        ERROR,
        WARN,
        INFO,
        DEBUG;

    }
}

