/*
 * Decompiled with CFR 0.152.
 */
package com.tc.handler;

import com.tc.handler.CallbackDirtyDatabaseCleanUpAdapter;
import com.tc.handler.CallbackHandlerResources;
import com.tc.logging.CallbackOnExitState;
import com.tc.objectserver.persistence.ClusterStatePersistor;
import com.tc.properties.TCProperties;
import com.tc.properties.TCPropertiesImpl;
import org.slf4j.Logger;

public class CallbackZapDirtyDbExceptionAdapter
extends CallbackDirtyDatabaseCleanUpAdapter {
    private static final TCProperties l2Props = TCPropertiesImpl.getProperties();
    private final Logger consoleLogger;

    public CallbackZapDirtyDbExceptionAdapter(Logger logger, Logger consoleLogger, ClusterStatePersistor clusterStateStore) {
        super(logger, clusterStateStore);
        this.consoleLogger = consoleLogger;
    }

    @Override
    public void callbackOnExit(CallbackOnExitState state) {
        super.callbackOnExit(state);
        boolean autoDelete = l2Props.getBoolean("l2.nha.dirtydb.autoDelete", true);
        boolean autoRestart = l2Props.getBoolean("l2.nha.autoRestart", true);
        if (autoDelete && autoRestart) {
            this.consoleLogger.error(CallbackHandlerResources.getDirtyDBAutodeleteAutoRestartZapMessage() + "\n");
        } else if (autoDelete && !autoRestart) {
            this.consoleLogger.error(CallbackHandlerResources.getDirtyDBAutodeleteZapMessage() + "\n");
        } else if (!autoDelete && autoRestart) {
            this.consoleLogger.error(CallbackHandlerResources.getDirtyDBAutoRestartZapMessage() + "\n");
        } else {
            this.consoleLogger.error(CallbackHandlerResources.getDirtyDBZapMessage() + "\n");
        }
    }
}

