/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config;

import com.tc.classloader.ServiceLocator;
import com.tc.config.GroupConfiguration;
import com.tc.productinfo.ProductInfo;
import com.tc.properties.TCPropertiesImpl;
import com.tc.text.PrettyPrintable;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.terracotta.configuration.Configuration;
import org.terracotta.configuration.ConfigurationException;
import org.terracotta.configuration.ConfigurationProvider;
import org.terracotta.configuration.ServerConfiguration;

public class ServerConfigurationManager
implements PrettyPrintable {
    private final ConfigurationProvider configurationProvider;
    private final ServiceLocator serviceLocator;
    private final List<String> startUpArgs;
    private final ProductInfo productInfo;
    private Configuration configuration;
    private ServerConfiguration serverConfiguration;

    public ServerConfigurationManager(ConfigurationProvider configurationProvider, ServiceLocator classLoader, List<String> startUpArgs) {
        Objects.requireNonNull(configurationProvider);
        Objects.requireNonNull(classLoader);
        Objects.requireNonNull(startUpArgs);
        this.configurationProvider = configurationProvider;
        this.serviceLocator = classLoader;
        this.startUpArgs = startUpArgs;
        this.productInfo = this.generateProductInfo(this.serviceLocator);
    }

    private ProductInfo generateProductInfo(ServiceLocator locator) {
        return ProductInfo.getInstance((ClassLoader)locator.createUniversalClassLoader());
    }

    public ProductInfo getProductInfo() {
        return this.productInfo;
    }

    public void initialize() throws ConfigurationException {
        this.configurationProvider.initialize(this.startUpArgs);
        this.configuration = this.configurationProvider.getConfiguration();
        if (this.configuration == null) {
            throw new ConfigurationException("unable to determine server configuration");
        }
        this.serverConfiguration = this.configuration.getServerConfiguration();
        if (this.serverConfiguration == null) {
            throw new ConfigurationException("unable to determine server configuration");
        }
        ServerConfigurationManager.processTcProperties(this.configuration.getTcProperties());
    }

    public void close() {
        this.configurationProvider.close();
    }

    public String[] getProcessArguments() {
        return this.startUpArgs.toArray(new String[this.startUpArgs.size()]);
    }

    public ServerConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    public GroupConfiguration getGroupConfiguration() {
        Map<String, ServerConfiguration> serverConfigurationMap = this.getServerConfigurationMap(this.configuration.getServerConfigurations());
        return new GroupConfiguration(serverConfigurationMap, this.serverConfiguration.getName());
    }

    public InputStream rawConfigFile() {
        String text = this.configuration.getRawConfiguration();
        return new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8));
    }

    public String rawConfigString() {
        return this.configuration.getRawConfiguration();
    }

    public String[] allCurrentlyKnownServers() {
        return this.getGroupConfiguration().getMembers();
    }

    public boolean isPartialConfiguration() {
        return this.configuration.isPartialConfiguration();
    }

    public ServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public ConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider;
    }

    private Map<String, ServerConfiguration> getServerConfigurationMap(Collection<ServerConfiguration> servers) {
        HashMap<String, ServerConfiguration> serverConfigurationMap = new HashMap<String, ServerConfiguration>();
        for (ServerConfiguration server : servers) {
            if (server.getName() == null) continue;
            serverConfigurationMap.put(server.getName(), server);
        }
        return serverConfigurationMap;
    }

    private static void processTcProperties(Properties tcProperties) {
        HashMap propMap = new HashMap();
        if (tcProperties != null) {
            tcProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> propMap.put(k.toString().trim(), v.toString().trim())));
        }
        TCPropertiesImpl.getProperties().overwriteTcPropertiesFromConfig(propMap);
    }

    public Map<String, ?> getStateMap() {
        if (this.configuration instanceof PrettyPrintable) {
            return ((PrettyPrintable)this.configuration).getStateMap();
        }
        return Collections.emptyMap();
    }
}

