/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config;

import com.tc.net.TCSocketAddress;
import com.tc.net.groups.Node;
import com.tc.properties.TCPropertiesImpl;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.terracotta.configuration.ServerConfiguration;

public class GroupConfiguration {
    static final int SINGLE_SERVER_ELECTION_TIMEOUT = 0;
    static final int MULTI_SERVER_ELECTION_TIMEOUT = TCPropertiesImpl.getProperties().getInt("l2.election.timeout", 5);
    private final Set<String> members = new HashSet<String>();
    private final Set<Node> nodes = new HashSet<Node>();
    private final Set<String> hostPorts = new HashSet<String>();
    private final Node currentNode;

    GroupConfiguration(Map<String, ServerConfiguration> configMap, String serverName) {
        this.members.addAll(configMap.keySet());
        Node current = null;
        for (Map.Entry<String, ServerConfiguration> member : configMap.entrySet()) {
            ServerConfiguration serverConfiguration = member.getValue();
            String bindAddress = serverConfiguration.getTsaPort().getHostName();
            if (TCSocketAddress.isWildcardAddress((String)bindAddress)) {
                bindAddress = serverConfiguration.getHost();
            }
            Node node = new Node(bindAddress, serverConfiguration.getTsaPort().getPort(), serverConfiguration.getGroupPort().getPort());
            this.hostPorts.add(node.getServerNodeName());
            if (serverName.equals(member.getKey())) {
                current = node;
            }
            this.nodes.add(node);
        }
        this.currentNode = current;
        if (MULTI_SERVER_ELECTION_TIMEOUT < 0) {
            throw new AssertionError((Object)"server election timeout cannot be less than zero");
        }
    }

    public Set<Node> getNodes() {
        return this.nodes;
    }

    public Node getCurrentNode() {
        return this.currentNode;
    }

    public int getElectionTimeInSecs() {
        return this.members.size() == 1 ? 0 : MULTI_SERVER_ELECTION_TIMEOUT;
    }

    public Set<String> getHostPorts() {
        return Collections.unmodifiableSet(this.hostPorts);
    }

    public String[] getMembers() {
        return this.members.toArray(new String[0]);
    }
}

