/*
 * Decompiled with CFR 0.152.
 */
package com.tc.classloader;

import com.tc.classloader.CommonComponentChecker;
import java.net.URL;
import java.net.URLClassLoader;

public class StrictURLClassLoader
extends URLClassLoader {
    private final CommonComponentChecker checker;
    ThreadLocal<String> topname = new ThreadLocal();

    public StrictURLClassLoader(URL[] urls, ClassLoader cl, CommonComponentChecker checker) {
        super(urls, cl);
        this.checker = checker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> target = null;
        String top = this.topname.get();
        if (top == null) {
            this.topname.set(name);
        }
        try {
            target = super.loadClass(name, resolve);
            if (target != null) {
                boolean thisLoader;
                boolean bl = thisLoader = target.getClassLoader() == this;
                if (thisLoader) {
                    boolean common;
                    boolean bl2 = common = top == null ? this.checker.check(target) : true;
                    if (!common) {
                        target = null;
                    }
                }
            }
        }
        catch (NoClassDefFoundError err) {
            target = null;
        }
        finally {
            if (top == null) {
                this.topname.remove();
            }
        }
        if (target == null) {
            throw new ClassNotFoundException(name);
        }
        return target;
    }

    @Override
    protected Package getPackage(String name) {
        return super.getPackage(name);
    }

    @Override
    protected Package definePackage(String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) throws IllegalArgumentException {
        return null;
    }
}

