/*
 * Decompiled with CFR 0.152.
 */
package com.tc.classloader;

import com.tc.classloader.AnnotationOrDirectoryStrategyChecker;
import com.tc.classloader.ApiClassLoader;
import com.tc.classloader.CommonComponentChecker;
import com.tc.classloader.ComponentURLClassLoader;
import com.tc.classloader.StrictURLClassLoader;
import com.tc.classloader.UniversalCommonComponentChecker;
import com.tc.properties.TCPropertiesImpl;
import com.tc.server.Directories;
import com.tc.util.ManagedServiceLoader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceLocator
extends ManagedServiceLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceLocator.class);
    private static final boolean STRICT = !TCPropertiesImpl.getProperties().getBoolean("server.classloader.compatibility");
    private final ClassLoader defaultClassLoader;
    private final Map<String, ClassLoader> locationCache = new ConcurrentHashMap<String, ClassLoader>();

    public ServiceLocator(ClassLoader parent) {
        this.defaultClassLoader = parent;
    }

    protected Class<?> loadClass(String className, String location, ClassLoader loader) {
        try {
            ClassLoader component = this.locationCache.computeIfAbsent(location, loc -> this.createComponentClassLoader((String)loc, loader));
            if (component != null) {
                return Class.forName(className, true, component);
            }
        }
        catch (ClassNotFoundException nf) {
            LOG.warn("unable to load " + className + " from " + location, (Throwable)nf);
        }
        return super.loadClass(className, location, loader);
    }

    private ClassLoader createComponentClassLoader(String location, ClassLoader parent) {
        try {
            return new ComponentURLClassLoader(new URL[]{new URL(location)}, parent, new AnnotationOrDirectoryStrategyChecker());
        }
        catch (MalformedURLException aml) {
            LOG.warn("unable to load " + location, (Throwable)aml);
            return null;
        }
    }

    private static boolean fileFilter(Path target) {
        String name = target.toString().toLowerCase();
        return name.endsWith(".jar") || name.endsWith(".zip");
    }

    private static URL toURL(Path uri) {
        try {
            return uri.toUri().toURL();
        }
        catch (MalformedURLException mal) {
            return null;
        }
    }

    private static URL[] createURLS(Path plugins) {
        if (Files.isDirectory(plugins, new LinkOption[0])) {
            try {
                return (URL[])Files.list(plugins).filter(ServiceLocator::fileFilter).map(ServiceLocator::toURL).filter(u -> u != null).toArray(URL[]::new);
            }
            catch (IOException io) {
                throw new UncheckedIOException(io);
            }
        }
        throw new RuntimeException("plugins directory is not valid");
    }

    private static URL[] findPluginURLS() throws FileNotFoundException {
        return ServiceLocator.createURLS(Directories.getServerPluginsLibDir());
    }

    public static ServiceLocator createPlatformServiceLoader(ClassLoader serverClassLoader) {
        return new ServiceLocator(ServiceLocator.createPlatformClassLoader(serverClassLoader, STRICT));
    }

    public ClassLoader createUniversalClassLoader() {
        try {
            return new StrictURLClassLoader(ServiceLocator.findPluginURLS(), this.defaultClassLoader.getParent(), new UniversalCommonComponentChecker());
        }
        catch (FileNotFoundException file) {
            return ClassLoader.getSystemClassLoader();
        }
    }

    private static ClassLoader createPlatformClassLoader(ClassLoader serverClassLoader, boolean strict) {
        try {
            CommonComponentChecker checker = strict ? new AnnotationOrDirectoryStrategyChecker() : new UniversalCommonComponentChecker();
            StrictURLClassLoader purls = new StrictURLClassLoader(ServiceLocator.findPluginURLS(), (ClassLoader)ServiceLocator.createApiClassLoader(serverClassLoader), checker);
            return purls;
        }
        catch (FileNotFoundException file) {
            return ClassLoader.getSystemClassLoader();
        }
    }

    private static ApiClassLoader createApiClassLoader(ClassLoader parent) {
        try {
            return new ApiClassLoader(ServiceLocator.createURLS(Directories.getServerPluginsApiDir()), parent);
        }
        catch (FileNotFoundException notfound) {
            return new ApiClassLoader(new URL[0], parent);
        }
    }

    Collection<Class<?>> testingCheckUrls(String interfaceName) {
        return this.discoverImplementations(interfaceName, this.defaultClassLoader);
    }

    public <T> List<Class<? extends T>> getImplementations(Class<T> interfaceClass) {
        return super.getImplementationsTypes(interfaceClass, this.defaultClassLoader);
    }

    public ClassLoader getServiceLoader() {
        return this.defaultClassLoader;
    }
}

