/*
 * Decompiled with CFR 0.152.
 */
package com.tc.classloader;

import com.tc.classloader.CommonComponentChecker;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentURLClassLoader
extends URLClassLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentURLClassLoader.class);
    private final CommonComponentChecker commonComponentChecker;

    public ComponentURLClassLoader(URL[] urls, ClassLoader parent, CommonComponentChecker commonComponentChecker) {
        super(urls, parent);
        this.commonComponentChecker = commonComponentChecker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> target = null;
        try {
            target = super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (target == null || !this.commonComponentChecker.check(target) && target.getClassLoader() != this) {
            try {
                Object object = this.getClassLoadingLock(name);
                synchronized (object) {
                    target = this.findClass(name);
                    if (resolve) {
                        this.resolveClass(target);
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (target == null) {
            throw new ClassNotFoundException(name);
        }
        return target;
    }

    public String toString() {
        return "ComponentURLClassLoader{from:" + Arrays.toString(this.getURLs()) + '}';
    }
}

