/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.config;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.config.BindPort;
import org.terracotta.config.Config;
import org.terracotta.config.Server;
import org.terracotta.config.Servers;
import org.terracotta.config.Service;
import org.terracotta.config.TCConfigurationSetupException;
import org.terracotta.config.TcConfig;
import org.terracotta.config.TcConfiguration;
import org.terracotta.config.service.ConfigValidator;
import org.terracotta.config.service.ExtendedConfigParser;
import org.terracotta.config.service.ServiceConfigParser;
import org.terracotta.config.util.DefaultSubstitutor;
import org.terracotta.config.util.ParameterSubstitutor;
import org.terracotta.entity.ServiceProviderConfiguration;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TCConfigurationParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(TCConfigurationParser.class);
    private static final SchemaFactory XSD_SCHEMA_FACTORY = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    public static final URL TERRACOTTA_XML_SCHEMA = TCConfigurationParser.class.getResource("/terracotta.xsd");
    private static final String WILDCARD_IP = "0.0.0.0";
    public static final int MIN_PORTNUMBER = 4095;
    public static final int MAX_PORTNUMBER = 65535;
    public static final String DEFAULT_LOGS = "logs";
    private static final Map<URI, ServiceConfigParser> serviceParsers = new HashMap<URI, ServiceConfigParser>();
    private static final Map<URI, ExtendedConfigParser> configParsers = new HashMap<URI, ExtendedConfigParser>();

    private static TcConfiguration parseStream(InputStream in, String source, ClassLoader loader) throws IOException, SAXException {
        DocumentBuilder documentBuilder;
        ArrayList<Source> schemaSources = new ArrayList<Source>();
        schemaSources.add(new StreamSource(TERRACOTTA_XML_SCHEMA.openStream()));
        for (ServiceConfigParser serviceConfigParser : TCConfigurationParser.loadServiceConfigurationParserClasses(loader)) {
            schemaSources.add(serviceConfigParser.getXmlSchema());
            serviceParsers.put(serviceConfigParser.getNamespace(), serviceConfigParser);
        }
        for (ExtendedConfigParser extendedConfigParser : TCConfigurationParser.loadConfigurationParserClasses(loader)) {
            schemaSources.add(extendedConfigParser.getXmlSchema());
            configParsers.put(extendedConfigParser.getNamespace(), extendedConfigParser);
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setSchema(XSD_SCHEMA_FACTORY.newSchema(schemaSources.toArray(new Source[schemaSources.size()])));
        try {
            documentBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
        CollectingErrorHandler errorHandler = new CollectingErrorHandler();
        documentBuilder.setErrorHandler(errorHandler);
        Element config = documentBuilder.parse(in).getDocumentElement();
        Collection<SAXParseException> parseErrors = errorHandler.getErrors();
        if (parseErrors.size() != 0) {
            StringBuffer buf = new StringBuffer("Couldn't parse configuration file, there are " + parseErrors.size() + " error(s).\n");
            int i = 1;
            for (SAXParseException parseError : parseErrors) {
                buf.append(" [" + i + "] Line " + parseError.getLineNumber() + ", column " + parseError.getColumnNumber() + ": " + parseError.getMessage() + "\n");
                ++i;
            }
            throw new TCConfigurationSetupException(buf.toString());
        }
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"org.terracotta.config", (ClassLoader)TCConfigurationParser.class.getClassLoader());
            Unmarshaller u = jc.createUnmarshaller();
            TcConfig tcConfig = (TcConfig)u.unmarshal((Node)config, TcConfig.class).getValue();
            if (tcConfig.getServers() == null) {
                Servers servers = new Servers();
                tcConfig.setServers(servers);
            }
            if (tcConfig.getServers().getServer().isEmpty()) {
                tcConfig.getServers().getServer().add(new Server());
            }
            DefaultSubstitutor.applyDefaults(tcConfig);
            TCConfigurationParser.applyPlatformDefaults(tcConfig, source);
            ArrayList<ServiceProviderConfiguration> serviceConfigurations = new ArrayList<ServiceProviderConfiguration>();
            ArrayList<Object> configObjects = new ArrayList<Object>();
            if (tcConfig.getPlugins() != null && tcConfig.getPlugins().getConfigOrService() != null) {
                for (Object plugin : tcConfig.getPlugins().getConfigOrService()) {
                    Object parser;
                    URI namespace;
                    Element element;
                    if (plugin instanceof Service) {
                        element = ((Service)plugin).getServiceContent();
                        namespace = URI.create(element.getNamespaceURI());
                        parser = serviceParsers.get(namespace);
                        if (parser == null) {
                            throw new TCConfigurationSetupException("Can't find parser for service " + namespace);
                        }
                        ServiceProviderConfiguration serviceProviderConfiguration = parser.parse(element, source);
                        serviceConfigurations.add(serviceProviderConfiguration);
                        continue;
                    }
                    if (!(plugin instanceof Config)) continue;
                    element = ((Config)plugin).configContent;
                    namespace = URI.create(element.getNamespaceURI());
                    parser = configParsers.get(namespace);
                    if (parser == null) {
                        throw new TCConfigurationSetupException("Can't find parser for config " + namespace);
                    }
                    Object co = parser.parse(element, source);
                    configObjects.add(co);
                }
            }
            return new TcConfiguration(tcConfig, source, configObjects, serviceConfigurations);
        }
        catch (JAXBException e) {
            throw new TCConfigurationSetupException((Exception)((Object)e));
        }
    }

    private static void applyPlatformDefaults(TcConfig tcConfig, String source) {
        for (Server server : tcConfig.getServers().getServer()) {
            TCConfigurationParser.setDefaultBind(server);
            TCConfigurationParser.initializeTsaPort(server);
            TCConfigurationParser.initializeTsaGroupPort(server);
            TCConfigurationParser.initializeNameAndHost(server);
            TCConfigurationParser.initializeLogsDirectory(server, source);
        }
    }

    private static void initializeTsaPort(Server server) {
        if (server.getTsaPort() == null) {
            BindPort tsaPort = new BindPort();
            tsaPort.setValue(9410);
            server.setTsaPort(tsaPort);
        }
        if (server.getTsaPort().getBind() == null) {
            server.getTsaPort().setBind(server.getBind());
        }
    }

    private static void initializeLogsDirectory(Server server, String source) {
        if (server.getLogs() == null) {
            server.setLogs("logs/%h-" + server.getTsaPort().getValue());
        }
        server.setLogs(TCConfigurationParser.getAbsolutePath(ParameterSubstitutor.substitute(server.getLogs()), new File(source != null ? source : ".")));
    }

    private static String getAbsolutePath(String substituted, File directoryLoadedFrom) {
        File out = new File(substituted);
        if (!out.isAbsolute()) {
            out = new File(directoryLoadedFrom, substituted);
        }
        return out.toPath().normalize().toString();
    }

    private static void initializeTsaGroupPort(Server server) {
        if (server.getTsaGroupPort() == null) {
            BindPort l2GrpPort = new BindPort();
            server.setTsaGroupPort(l2GrpPort);
            int tempGroupPort = server.getTsaPort().getValue() + 20;
            int defaultGroupPort = tempGroupPort <= 65535 ? tempGroupPort : tempGroupPort % 65535 + 4095;
            l2GrpPort.setValue(defaultGroupPort);
            l2GrpPort.setBind(server.getBind());
        } else if (server.getTsaGroupPort().getBind() == null) {
            server.getTsaGroupPort().setBind(server.getBind());
        }
    }

    private static void initializeNameAndHost(Server server) {
        if (server.getHost() == null || server.getHost().trim().length() == 0) {
            if (server.getName() == null) {
                server.setHost("%i");
            } else {
                server.setHost(server.getName());
            }
        }
        if (server.getName() == null || server.getName().trim().length() == 0) {
            int tsaPort = server.getTsaPort().getValue();
            server.setName(server.getHost() + (tsaPort > 0 ? ":" + tsaPort : ""));
        }
        server.setHost(ParameterSubstitutor.substitute(server.getHost()));
        server.setName(ParameterSubstitutor.substitute(server.getName()));
    }

    private static void setDefaultBind(Server s) {
        if (s.getBind() == null || s.getBind().trim().length() == 0) {
            s.setBind(WILDCARD_IP);
        }
        s.setBind(ParameterSubstitutor.substitute(s.getBind()));
    }

    private static TcConfiguration convert(InputStream in, String path, ClassLoader loader) throws IOException, SAXException {
        byte[] data = new byte[in.available()];
        in.read(data);
        in.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        return TCConfigurationParser.parseStream(bais, path, loader);
    }

    public static TcConfiguration parse(File f) throws IOException, SAXException {
        return TCConfigurationParser.parse(f, Thread.currentThread().getContextClassLoader());
    }

    public static TcConfiguration parse(File file, ClassLoader loader) throws IOException, SAXException {
        try (FileInputStream in = new FileInputStream(file);){
            TcConfiguration tcConfiguration = TCConfigurationParser.convert(in, file.getParent(), loader);
            return tcConfiguration;
        }
    }

    public static TcConfiguration parse(String xmlText) throws IOException, SAXException {
        return TCConfigurationParser.parse(xmlText, Thread.currentThread().getContextClassLoader());
    }

    public static TcConfiguration parse(String xmlText, ClassLoader loader) throws IOException, SAXException {
        return TCConfigurationParser.convert(new ByteArrayInputStream(xmlText.getBytes()), null, loader);
    }

    public static TcConfiguration parse(InputStream stream) throws IOException, SAXException {
        return TCConfigurationParser.parse(stream, Thread.currentThread().getContextClassLoader());
    }

    public static TcConfiguration parse(InputStream stream, ClassLoader loader) throws IOException, SAXException {
        return TCConfigurationParser.convert(stream, null, loader);
    }

    public static TcConfiguration parse(URL stream) throws IOException, SAXException {
        return TCConfigurationParser.parse(stream, Thread.currentThread().getContextClassLoader());
    }

    public static TcConfiguration parse(URL url, ClassLoader loader) throws IOException, SAXException {
        return TCConfigurationParser.convert(url.openStream(), url.getPath(), loader);
    }

    public static TcConfiguration parse(InputStream in, Collection<SAXParseException> errors, String source) throws IOException, SAXException {
        return TCConfigurationParser.parse(in, errors, source, Thread.currentThread().getContextClassLoader());
    }

    public static TcConfiguration parse(InputStream in, Collection<SAXParseException> errors, String source, ClassLoader loader) throws IOException, SAXException {
        return TCConfigurationParser.parseStream(in, source, loader);
    }

    public static ConfigValidator getValidator(URI namespace) {
        ServiceConfigParser parserObject = serviceParsers.get(namespace);
        if (parserObject != null) {
            return parserObject.getConfigValidator();
        }
        ExtendedConfigParser extendedConfigParser = configParsers.get(namespace);
        if (extendedConfigParser != null) {
            return extendedConfigParser.getConfigValidator();
        }
        return null;
    }

    private static ServiceLoader<ServiceConfigParser> loadServiceConfigurationParserClasses(ClassLoader loader) {
        return ServiceLoader.load(ServiceConfigParser.class, loader);
    }

    private static ServiceLoader<ExtendedConfigParser> loadConfigurationParserClasses(ClassLoader loader) {
        return ServiceLoader.load(ExtendedConfigParser.class, loader);
    }

    private static class CollectingErrorHandler
    implements ErrorHandler {
        private final List<SAXParseException> errors = new ArrayList<SAXParseException>();

        private CollectingErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.errors.add(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.errors.add(exception);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            LOGGER.warn(exception.getLocalizedMessage());
        }

        public Collection<SAXParseException> getErrors() {
            return Collections.unmodifiableList(this.errors);
        }
    }
}

