/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.testing.support;

import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import org.terracotta.utilities.test.net.PortManager;

public final class PortTool {
    public static void assignDebugPorts(PortManager portManager, int serverDebugStartPort, int serverCount, List<PortManager.PortRef> debugPortRefs, List<Integer> serverDebugPorts) {
        Objects.requireNonNull(portManager, "portManager");
        Objects.requireNonNull(debugPortRefs, "debugPortRefs");
        Objects.requireNonNull(serverDebugPorts, "serverDebugPorts");
        if (serverCount <= 0) {
            throw new IllegalArgumentException("serverCount must be greater than zero");
        }
        if (serverDebugStartPort == 0) {
            debugPortRefs.clear();
            IntStream.generate(() -> 0).limit(serverCount).boxed().forEach(serverDebugPorts::add);
        } else {
            if (serverDebugStartPort < 0 || serverDebugStartPort > 65535) {
                throw new IllegalArgumentException("serverDebugStartPort " + serverDebugStartPort + " is out of range");
            }
            int i = 0;
            while (i < serverCount) {
                int candidatePort = serverDebugStartPort;
                try {
                    debugPortRefs.add((PortManager.PortRef)portManager.reserve(candidatePort).orElseThrow(() -> new IllegalStateException("Debug candidate port " + candidatePort + " cannot be reserved")));
                }
                catch (IllegalArgumentException e) {
                    debugPortRefs.add(null);
                }
                serverDebugPorts.add(candidatePort);
                ++i;
                ++serverDebugStartPort;
            }
        }
    }
}

