/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.testing.rules;

import com.tc.util.Assert;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.terracotta.connection.Connection;
import org.terracotta.connection.ConnectionException;
import org.terracotta.connection.ConnectionFactory;
import org.terracotta.passthrough.IClusterControl;
import org.terracotta.testing.config.StartupCommandBuilder;
import org.terracotta.testing.config.StripeConfiguration;
import org.terracotta.testing.config.TcConfigBuilder;
import org.terracotta.testing.logging.ContextualLogger;
import org.terracotta.testing.logging.VerboseLogger;
import org.terracotta.testing.logging.VerboseManager;
import org.terracotta.testing.master.FileHelpers;
import org.terracotta.testing.master.GalvanFailureException;
import org.terracotta.testing.master.ITestStateManager;
import org.terracotta.testing.master.ITestWaiter;
import org.terracotta.testing.master.InlineStripeInstaller;
import org.terracotta.testing.master.ReadyStripe;
import org.terracotta.testing.master.StateInterlock;
import org.terracotta.testing.master.TestStateManager;
import org.terracotta.testing.rules.Cluster;
import org.terracotta.testing.rules.IsolatedClassLoader;
import org.terracotta.testing.rules.TestManager;
import org.terracotta.testing.support.PortTool;
import org.terracotta.utilities.test.net.PortManager;

class BasicInlineCluster
extends Cluster {
    private final Path clusterDirectory;
    private final int stripeSize;
    private final Set<Path> serverJars;
    private final String namespaceFragment;
    private final String serviceFragment;
    private final int clientReconnectWindow;
    private final int voterCount;
    private final boolean consistentStart;
    private final Properties tcProperties = new Properties();
    private final Properties systemProperties = new Properties();
    private final String logConfigExt;
    private final int serverHeapSize;
    private final Supplier<StartupCommandBuilder> startupBuilder;
    private final PortManager allocator = PortManager.getInstance();
    private String displayName;
    private ReadyStripe cluster;
    private StateInterlock interlock;
    private TestStateManager stateManager;
    private final Thread clientThread;
    private volatile boolean isInterruptingClient;
    private Thread shepherdingThread;
    private boolean isSafe;

    BasicInlineCluster(Path clusterDirectory, int stripeSize, Set<Path> serverJars, String namespaceFragment, String serviceFragment, int clientReconnectWindow, int voterCount, boolean consistentStart, Properties tcProperties, Properties systemProperties, String logConfigExt, int serverHeapSize, Supplier<StartupCommandBuilder> startupBuilder) {
        boolean didCreateDirectories = clusterDirectory.toFile().mkdirs();
        if (Files.exists(clusterDirectory, new LinkOption[0])) {
            if (Files.isRegularFile(clusterDirectory, new LinkOption[0])) {
                throw new IllegalArgumentException("Cluster directory is a file: " + clusterDirectory);
            }
        } else if (!didCreateDirectories) {
            throw new IllegalArgumentException("Cluster directory could not be created: " + clusterDirectory);
        }
        this.clusterDirectory = clusterDirectory;
        this.stripeSize = stripeSize;
        this.namespaceFragment = namespaceFragment;
        this.serviceFragment = serviceFragment;
        this.serverJars = serverJars;
        this.clientReconnectWindow = clientReconnectWindow;
        this.voterCount = voterCount;
        this.consistentStart = consistentStart;
        this.tcProperties.putAll((Map<?, ?>)tcProperties);
        this.systemProperties.putAll((Map<?, ?>)systemProperties);
        this.logConfigExt = logConfigExt;
        this.serverHeapSize = serverHeapSize;
        this.startupBuilder = startupBuilder;
        this.clientThread = Thread.currentThread();
    }

    public Statement apply(Statement base, Description description) {
        String methodName = description.getMethodName();
        Class testClass = description.getTestClass();
        this.displayName = methodName == null ? (testClass == null ? description.getDisplayName() : testClass.getSimpleName()) : (testClass == null ? description.getDisplayName() : testClass.getSimpleName() + "-" + methodName);
        return super.apply(base, description);
    }

    @Override
    public CompletionStage<Void> manualStart(String displayName) {
        this.displayName = displayName;
        CompletableFuture<Void> f = new CompletableFuture<Void>();
        try {
            this.internalStart(f);
        }
        catch (Throwable t) {
            f.completeExceptionally(t);
        }
        return f;
    }

    protected void before() throws Throwable {
        this.internalStart(new CompletableFuture<Void>());
    }

    @Override
    public TestManager getTestManager() {
        return new TestManager(){

            @Override
            public void testFinished() {
                BasicInlineCluster.this.stateManager.setTestDidPassIfNotFailed();
            }

            @Override
            public void testDidFail(GalvanFailureException failure) {
                BasicInlineCluster.this.stateManager.testDidFail(failure);
            }

            @Override
            public boolean isComplete() throws GalvanFailureException {
                return BasicInlineCluster.this.stateManager.checkDidPass();
            }
        };
    }

    private void internalStart(final CompletableFuture<Void> checker) throws Throwable {
        VerboseLogger harnessLogger = new VerboseLogger(System.out, null);
        VerboseLogger fileHelpersLogger = new VerboseLogger(null, null);
        VerboseLogger clientLogger = null;
        VerboseLogger serverLogger = new VerboseLogger(System.out, System.err);
        VerboseManager verboseManager = new VerboseManager("", harnessLogger, fileHelpersLogger, clientLogger, serverLogger);
        VerboseManager displayVerboseManager = verboseManager.createComponentManager("[" + this.displayName + "]");
        String kitInstallationPath = System.getProperty("kitInstallationPath");
        harnessLogger.output("Using kitInstallationPath: \"" + kitInstallationPath + "\"");
        System.setProperty("tc.install-root", kitInstallationPath + File.separator + "server");
        System.setProperty("restart.inline", Boolean.TRUE.toString());
        System.setProperty("com.tc.server.entity.processor.threads", "4");
        System.setProperty("com.tc.l2.tccom.workerthreads", "4");
        Path kitDir = Paths.get(kitInstallationPath, new String[0]);
        File testParentDir = File.createTempFile(this.displayName, "", this.clusterDirectory.toFile());
        testParentDir.delete();
        testParentDir.mkdir();
        String debugPortString = System.getProperty("serverDebugPortStart");
        int serverDebugStartPort = debugPortString != null ? Integer.parseInt(debugPortString) : 0;
        this.stateManager = new TestStateManager();
        this.interlock = new StateInterlock(verboseManager.createComponentManager("[Interlock]").createHarnessLogger(), (ITestWaiter)this.stateManager);
        final ArrayList<PortManager.PortRef> debugPortRefs = new ArrayList<PortManager.PortRef>();
        ArrayList<Integer> serverDebugPorts = new ArrayList<Integer>();
        PortTool.assignDebugPorts(this.allocator, serverDebugStartPort, this.stripeSize, debugPortRefs, serverDebugPorts);
        final List serverPortRefs = this.allocator.reservePorts(this.stripeSize);
        final List groupPortRefs = this.allocator.reservePorts(this.stripeSize);
        List<Integer> serverPorts = serverPortRefs.stream().map(PortManager.PortRef::port).collect(Collectors.toList());
        List<Integer> serverGroupPorts = groupPortRefs.stream().map(PortManager.PortRef::port).collect(Collectors.toList());
        List<String> serverNames = IntStream.range(0, this.stripeSize).mapToObj(i -> "testServer" + i).collect(Collectors.toList());
        String stripeName = "stripe1";
        Path stripeInstallationDir = testParentDir.toPath().resolve(stripeName);
        Files.createDirectory(stripeInstallationDir, new FileAttribute[0]);
        VerboseManager stripeVerboseManager = displayVerboseManager.createComponentManager("[" + stripeName + "]");
        Path tcConfig = this.createTcConfig(serverNames, serverPorts, serverGroupPorts, stripeInstallationDir);
        Path kitLocation = this.installKit(stripeVerboseManager, kitDir, this.serverJars, stripeInstallationDir);
        StripeConfiguration stripeConfig = new StripeConfiguration(serverDebugPorts, serverPorts, serverGroupPorts, serverNames, stripeName, this.serverHeapSize, this.logConfigExt, this.systemProperties);
        InlineStripeInstaller stripeInstaller = new InlineStripeInstaller(this.interlock, (ITestStateManager)this.stateManager, stripeVerboseManager, stripeConfig);
        for (int i2 = 0; i2 < this.stripeSize; ++i2) {
            String serverName = serverNames.get(i2);
            Path serverWorkingDir = stripeInstallationDir.resolve(serverName);
            Path tcConfigRelative = this.relativize(serverWorkingDir, tcConfig);
            Path kitLocationRelative = this.relativize(serverWorkingDir, kitLocation);
            StartupCommandBuilder builder = this.startupBuilder.get().tcConfig(tcConfigRelative).serverName(serverName).stripeName(stripeName).serverWorkingDir(serverWorkingDir).kitDir(kitLocationRelative).logConfigExtension(this.logConfigExt).consistentStartup(this.consistentStart);
            String[] cmd = builder.build();
            stripeInstaller.installNewServer(serverName, serverWorkingDir, stdout -> this.startIsolatedServer(serverWorkingDir, (OutputStream)stdout, cmd));
        }
        this.cluster = ReadyStripe.configureAndStartStripe((StateInterlock)this.interlock, (VerboseManager)stripeVerboseManager, (StripeConfiguration)stripeConfig, (InlineStripeInstaller)stripeInstaller);
        Assert.assertTrue((null == this.shepherdingThread ? 1 : 0) != 0);
        this.shepherdingThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                BasicInlineCluster.this.setSafeForRun(true);
                boolean didPass = false;
                try {
                    BasicInlineCluster.this.stateManager.waitForFinish();
                    didPass = true;
                    return;
                }
                catch (GalvanFailureException e) {
                    e.printStackTrace();
                    checker.completeExceptionally(e);
                    didPass = false;
                    return;
                }
                finally {
                    try {
                        BasicInlineCluster.this.interlock.forceShutdown();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        didPass = false;
                    }
                    finally {
                        BasicInlineCluster.this.setSafeForRun(false);
                        serverPortRefs.forEach(PortManager.PortRef::close);
                        groupPortRefs.forEach(PortManager.PortRef::close);
                        debugPortRefs.stream().filter(Objects::nonNull).forEach(PortManager.PortRef::close);
                        if (!didPass) {
                            BasicInlineCluster.this.isInterruptingClient = true;
                            BasicInlineCluster.this.clientThread.interrupt();
                        }
                    }
                }
            }
        };
        this.shepherdingThread.setName("Shepherding Thread");
        this.shepherdingThread.start();
        this.waitForSafe();
    }

    private Object startIsolatedServer(Path serverWorking, OutputStream out, String[] cmd) {
        if (cmd[0].contains("start-tc-server")) {
            cmd = Arrays.copyOfRange(cmd, 1, cmd.length);
        }
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Path tc = Paths.get(System.getProperty("tc.install-root"), "lib", "tc.jar");
        try {
            Thread.currentThread().setContextClassLoader(null);
            URL url = tc.toUri().toURL();
            URL resource = serverWorking.toUri().toURL();
            IsolatedClassLoader loader = new IsolatedClassLoader(new URL[]{resource, url}, ((Object)((Object)this)).getClass().getClassLoader());
            Method m = Class.forName("com.tc.server.TCServerMain", true, loader).getMethod("createServer", List.class, OutputStream.class);
            Object object = m.invoke(null, Arrays.asList(cmd), out);
            return object;
        }
        catch (RuntimeException mal) {
            throw mal;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    private Path relativize(Path root, Path other) {
        return root.toAbsolutePath().relativize(other.toAbsolutePath());
    }

    private Path createTcConfig(List<String> serverNames, List<Integer> serverPorts, List<Integer> serverGroupPorts, Path stripeInstallationDir) {
        TcConfigBuilder configBuilder = new TcConfigBuilder(stripeInstallationDir, serverNames, serverPorts, serverGroupPorts, this.tcProperties, this.namespaceFragment, this.serviceFragment, this.clientReconnectWindow, this.voterCount);
        String tcConfig = configBuilder.build();
        try {
            Path tcConfigPath = Files.createFile(stripeInstallationDir.resolve("tc-config.xml"), new FileAttribute[0]);
            Files.write(tcConfigPath, tcConfig.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            return tcConfigPath;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Path installKit(VerboseManager logger, Path srcKit, Set<Path> extraJars, Path stripeInstall) throws IOException {
        if (extraJars.isEmpty()) {
            return srcKit;
        }
        ContextualLogger clogger = logger.createFileHelpersLogger();
        Path stripeKit = FileHelpers.createTempCopyOfDirectory((ContextualLogger)clogger, (Path)stripeInstall, (String)"installedKit", (Path)srcKit);
        FileHelpers.copyJarsToServer((ContextualLogger)clogger, (Path)stripeKit, extraJars);
        return stripeKit;
    }

    public void manualStop() {
        this.internalStop();
    }

    protected void after() {
        this.internalStop();
    }

    private void internalStop() {
        this.stateManager.setTestDidPassIfNotFailed();
        try {
            this.shepherdingThread.join();
        }
        catch (InterruptedException ignorable) {
            Assert.assertTrue((boolean)this.isInterruptingClient);
            this.isInterruptingClient = false;
            try {
                this.shepherdingThread.join();
            }
            catch (InterruptedException unexpected) {
                Assert.fail((String)unexpected.getLocalizedMessage());
            }
        }
        this.shepherdingThread = null;
    }

    @Override
    public URI getConnectionURI() {
        return URI.create(this.cluster.getStripeUri());
    }

    @Override
    public String[] getClusterHostPorts() {
        return this.cluster.getStripeUri().substring("terracotta://".length()).split(",");
    }

    @Override
    public Connection newConnection() throws ConnectionException {
        if (!this.checkSafe()) {
            throw new ConnectionException(null);
        }
        return ConnectionFactory.connect((URI)this.getConnectionURI(), (Properties)new Properties());
    }

    @Override
    public IClusterControl getClusterControl() {
        return new IClusterControl(){

            public void waitForActive() throws Exception {
                BasicInlineCluster.this.cluster.getStripeControl().waitForActive();
            }

            public void waitForRunningPassivesInStandby() throws Exception {
                BasicInlineCluster.this.cluster.getStripeControl().waitForRunningPassivesInStandby();
            }

            public void startOneServer() throws Exception {
                BasicInlineCluster.this.cluster.getStripeControl().startOneServer();
            }

            public void startAllServers() throws Exception {
                BasicInlineCluster.this.cluster.getStripeControl().startAllServers();
            }

            public void terminateActive() throws Exception {
                BasicInlineCluster.this.cluster.getStripeControl().terminateActive();
            }

            public void terminateOnePassive() throws Exception {
                BasicInlineCluster.this.cluster.getStripeControl().terminateOnePassive();
            }

            public void terminateAllServers() throws Exception {
                BasicInlineCluster.this.cluster.getStripeControl().terminateAllServers();
            }
        };
    }

    private synchronized void setSafeForRun(boolean isSafe) {
        this.isSafe = isSafe;
        ((Object)((Object)this)).notifyAll();
    }

    private synchronized void waitForSafe() {
        boolean interrupted = false;
        while (!interrupted && !this.isSafe) {
            try {
                ((Object)((Object)this)).wait();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private synchronized boolean checkSafe() {
        return this.isSafe;
    }

    @Override
    public void expectCrashes(boolean yes) {
        this.interlock.ignoreServerCrashes(yes);
    }
}

