/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.testing.rules;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import org.terracotta.testing.config.ArgOnlyStartupCommandBuilder;
import org.terracotta.testing.config.DefaultStartupCommandBuilder;
import org.terracotta.testing.config.StartupCommandBuilder;
import org.terracotta.testing.rules.BasicExternalCluster;
import org.terracotta.testing.rules.BasicInlineCluster;
import org.terracotta.testing.rules.Cluster;

public class BasicExternalClusterBuilder {
    private final int stripeSize;
    private Path clusterDirectory = Paths.get("target", new String[0]).resolve("galvan");
    private Set<Path> serverJars = Collections.emptySet();
    private String namespaceFragment = "";
    private String serviceFragment = "";
    private int clientReconnectWindowTime = 120;
    private int failoverPriorityVoterCount = -1;
    private boolean consistentStart = false;
    private Properties tcProperties = new Properties();
    private Properties systemProperties = new Properties();
    private String logConfigExt = "logback-ext.xml";
    private int serverHeapSize = 128;
    private boolean inline = true;
    private Supplier<StartupCommandBuilder> startupBuilder;

    private BasicExternalClusterBuilder(int stripeSize) {
        this.stripeSize = stripeSize;
    }

    public static BasicExternalClusterBuilder newCluster() {
        return new BasicExternalClusterBuilder(1);
    }

    public static BasicExternalClusterBuilder newCluster(int stripeSize) {
        if (stripeSize < 1) {
            throw new IllegalArgumentException("Must be at least one server in the cluster");
        }
        return new BasicExternalClusterBuilder(stripeSize);
    }

    public BasicExternalClusterBuilder in(Path clusterDirectory) {
        if (clusterDirectory == null) {
            throw new NullPointerException("Cluster directory must be non-null");
        }
        this.clusterDirectory = clusterDirectory;
        return this;
    }

    public BasicExternalClusterBuilder withServerJars(Set<Path> serverJars) {
        if (serverJars == null) {
            throw new NullPointerException("Server JARs list must be non-null");
        }
        this.serverJars = serverJars;
        return this;
    }

    public BasicExternalClusterBuilder withNamespaceFragment(String namespaceFragment) {
        if (namespaceFragment == null) {
            throw new NullPointerException("Namespace fragment must be non-null");
        }
        this.namespaceFragment = namespaceFragment;
        return this;
    }

    public BasicExternalClusterBuilder withServiceFragment(String serviceFragment) {
        if (serviceFragment == null) {
            throw new NullPointerException("Service fragment must be non-null");
        }
        this.serviceFragment = serviceFragment;
        return this;
    }

    public BasicExternalClusterBuilder withClientReconnectWindowTime(int clientReconnectWindowTime) {
        this.clientReconnectWindowTime = clientReconnectWindowTime;
        return this;
    }

    public BasicExternalClusterBuilder withFailoverPriorityVoterCount(int failoverPriorityVoterCount) {
        this.failoverPriorityVoterCount = failoverPriorityVoterCount;
        return this;
    }

    public BasicExternalClusterBuilder withTcProperties(Properties tcProperties) {
        this.tcProperties.putAll((Map<?, ?>)tcProperties);
        return this;
    }

    public BasicExternalClusterBuilder withTcProperty(String key, String value) {
        this.tcProperties.put(key, value);
        return this;
    }

    public BasicExternalClusterBuilder withSystemProperties(Properties props) {
        this.systemProperties.putAll((Map<?, ?>)props);
        return this;
    }

    public BasicExternalClusterBuilder withSystemProperty(String key, String value) {
        this.systemProperties.put(key, value);
        return this;
    }

    public BasicExternalClusterBuilder withServerHeap(int heapSize) {
        this.serverHeapSize = heapSize;
        return this;
    }

    public BasicExternalClusterBuilder logConfigExtensionResourceName(String logConfigExt) {
        this.logConfigExt = logConfigExt;
        return this;
    }

    public BasicExternalClusterBuilder startupBuilder(Supplier<StartupCommandBuilder> startupBuilder) {
        this.startupBuilder = startupBuilder;
        return this;
    }

    public BasicExternalClusterBuilder inline(boolean yes) {
        this.inline = yes;
        return this;
    }

    public BasicExternalClusterBuilder withConsistentStartup(boolean consistent) {
        this.consistentStart = consistent;
        return this;
    }

    public Cluster build() {
        if (this.inline) {
            return new BasicInlineCluster(this.clusterDirectory, this.stripeSize, this.serverJars, this.namespaceFragment, this.serviceFragment, this.clientReconnectWindowTime, this.failoverPriorityVoterCount, this.consistentStart, this.tcProperties, this.systemProperties, this.logConfigExt, this.serverHeapSize, Optional.ofNullable(this.startupBuilder).orElse(ArgOnlyStartupCommandBuilder::new));
        }
        return new BasicExternalCluster(this.clusterDirectory, this.stripeSize, this.serverJars, this.namespaceFragment, this.serviceFragment, this.clientReconnectWindowTime, this.failoverPriorityVoterCount, this.consistentStart, this.tcProperties, this.systemProperties, this.logConfigExt, this.serverHeapSize, Optional.ofNullable(this.startupBuilder).orElse(DefaultStartupCommandBuilder::new));
    }
}

