/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.testing.plugin;

import com.tc.classloader.BuiltinService;
import com.tc.spi.Pauseable;
import com.tc.text.MapListPrettyPrint;
import com.tc.text.PrettyPrinter;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.Collections;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.terracotta.entity.PlatformConfiguration;
import org.terracotta.entity.ServiceConfiguration;
import org.terracotta.entity.ServiceProvider;
import org.terracotta.entity.ServiceProviderCleanupException;
import org.terracotta.entity.ServiceProviderConfiguration;
import org.terracotta.server.ServerEnv;

@BuiltinService
public class PauseControl
implements ServiceProvider {
    public boolean initialize(ServiceProviderConfiguration spc, PlatformConfiguration pc) {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName name = new ObjectName("org.terracotta:name=PauseControl");
            server.registerMBean(new PauseController(), name);
            return true;
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException jMException) {
            return false;
        }
    }

    public <T> T getService(long l, ServiceConfiguration<T> sc) {
        return null;
    }

    public Collection<Class<?>> getProvidedServiceTypes() {
        return Collections.emptySet();
    }

    public void prepareForSynchronization() throws ServiceProviderCleanupException {
    }

    public static interface PauseControlInterface {
        public void pause(String var1);

        public void unpause(String var1);

        public void setPauseNetwork(boolean var1);

        public boolean isPauseNetwork();

        public String getState();
    }

    public static class PauseController
    extends StandardMBean
    implements PauseControlInterface {
        private final Pauseable pause = (Pauseable)ServerEnv.getServer();
        private boolean networkPaused = false;

        public PauseController() throws NotCompliantMBeanException {
            super(PauseControlInterface.class, false);
        }

        @Override
        public void pause(String path) {
            this.pause.pause(path);
        }

        @Override
        public void unpause(String path) {
            this.pause.unpause(path);
        }

        @Override
        public void setPauseNetwork(boolean p) {
            if (p) {
                this.pause.pause("L1");
                this.pause.pause("L2");
            } else {
                this.pause.unpause("L1");
                this.pause.unpause("L2");
            }
            this.networkPaused = p;
        }

        @Override
        public boolean isPauseNetwork() {
            return this.networkPaused;
        }

        @Override
        public String getState() {
            MapListPrettyPrint pp = new MapListPrettyPrint();
            return this.pause.prettyPrint((PrettyPrinter)pp).toString();
        }
    }
}

