/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.testing.master;

import java.io.IOException;
import org.terracotta.testing.api.ITestMaster;
import org.terracotta.testing.logging.VerboseManager;
import org.terracotta.testing.master.BasicHarnessEntry;
import org.terracotta.testing.master.CommandLineSupport;
import org.terracotta.testing.master.DebugOptions;
import org.terracotta.testing.master.EnvironmentOptions;
import org.terracotta.testing.master.GalvanFailureException;

public class BasicHarnessMain {
    public static void main(String[] args) throws InterruptedException, IOException {
        EnvironmentOptions environmentOptions = CommandLineSupport.parseEnvironmentOptions((String[])args);
        String parsedMasterClass = CommandLineSupport.parseTestMasterClass((String[])args);
        if (environmentOptions.isValid() && null != parsedMasterClass) {
            DebugOptions debugOptions = CommandLineSupport.parseDebugOptions((String[])args);
            VerboseManager verboseManager = CommandLineSupport.parseVerbose((String[])args);
            ITestMaster master = null;
            try {
                master = CommandLineSupport.loadMaster((String)parsedMasterClass);
            }
            catch (Exception e) {
                System.err.println("FATAL: ITestMaster \"" + parsedMasterClass + "\" could not be used: " + e.getLocalizedMessage());
                e.printStackTrace();
                System.exit(1);
            }
            try {
                BasicHarnessEntry harness = new BasicHarnessEntry();
                harness.runTestHarness(environmentOptions, master, debugOptions, verboseManager);
                System.out.println("TEST RUN SUCCESSFUL!");
            }
            catch (GalvanFailureException e) {
                System.out.println("TEST FAILED! " + e.getLocalizedMessage());
                e.printStackTrace();
                System.exit(2);
            }
        } else {
            System.err.println(CommandLineSupport.getUsageString());
            System.exit(1);
        }
    }
}

