/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.testing.master;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.terracotta.testing.api.BasicTestClusterConfiguration;
import org.terracotta.testing.common.Assert;
import org.terracotta.testing.config.BasicClientArgumentBuilder;
import org.terracotta.testing.config.ClientsConfiguration;
import org.terracotta.testing.config.ClusterInfo;
import org.terracotta.testing.config.DefaultStartupCommandBuilder;
import org.terracotta.testing.config.IClientArgumentBuilder;
import org.terracotta.testing.config.StartupCommandBuilder;
import org.terracotta.testing.config.StripeConfiguration;
import org.terracotta.testing.config.TcConfigBuilder;
import org.terracotta.testing.logging.VerboseManager;
import org.terracotta.testing.master.AbstractHarnessEntry;
import org.terracotta.testing.master.ClientSubProcessManager;
import org.terracotta.testing.master.DebugOptions;
import org.terracotta.testing.master.GalvanFailureException;
import org.terracotta.testing.master.IGalvanStateInterlock;
import org.terracotta.testing.master.IMultiProcessControl;
import org.terracotta.testing.master.ITestStateManager;
import org.terracotta.testing.master.ITestWaiter;
import org.terracotta.testing.master.ReadyStripe;
import org.terracotta.testing.master.StateInterlock;
import org.terracotta.testing.master.StripeInstaller;
import org.terracotta.testing.master.TestStateManager;
import org.terracotta.testing.support.PortTool;
import org.terracotta.utilities.test.net.PortManager;

public class BasicHarnessEntry
extends AbstractHarnessEntry<BasicTestClusterConfiguration> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runOneConfiguration(VerboseManager verboseManager, DebugOptions debugOptions, AbstractHarnessEntry.CommonHarnessOptions harnessOptions, BasicTestClusterConfiguration runConfiguration) throws IOException, GalvanFailureException {
        int stripeSize = runConfiguration.serversInStripe;
        Assert.assertTrue((stripeSize > 0 ? 1 : 0) != 0);
        PortManager portManager = PortManager.getInstance();
        ArrayList<PortManager.PortRef> debugPortRefs = new ArrayList<PortManager.PortRef>();
        ArrayList<Integer> serverDebugPorts = new ArrayList<Integer>();
        PortTool.assignDebugPorts(portManager, debugOptions.serverDebugPortStart, stripeSize, debugPortRefs, serverDebugPorts);
        List serverPortRefs = portManager.reservePorts(stripeSize);
        List groupPortRefs = portManager.reservePorts(stripeSize);
        List<Integer> serverPorts = serverPortRefs.stream().map(PortManager.PortRef::port).collect(Collectors.toList());
        List<Integer> serverGroupPorts = groupPortRefs.stream().map(PortManager.PortRef::port).collect(Collectors.toList());
        List<String> serverNames = IntStream.range(0, stripeSize).mapToObj(i -> "testServer" + i).collect(Collectors.toList());
        String stripeName = "stripe1";
        Path stripeInstallationDir = harnessOptions.configTestDir.resolve(stripeName);
        Files.createDirectory(stripeInstallationDir, new FileAttribute[0]);
        Path tcConfig = this.createTcConfig(serverNames, serverPorts, serverGroupPorts, stripeInstallationDir, harnessOptions);
        VerboseManager stripeVerboseManager = verboseManager.createComponentManager("[" + stripeName + "]");
        StripeConfiguration stripeConfig = new StripeConfiguration(serverDebugPorts, serverPorts, serverGroupPorts, serverNames, stripeName, 128, "logback-ext.xml", harnessOptions.serverProperties);
        TestStateManager stateManager = new TestStateManager();
        StateInterlock interlock = new StateInterlock(verboseManager.createComponentManager("[Interlock]").createHarnessLogger(), (ITestWaiter)stateManager);
        StripeInstaller stripeInstaller = new StripeInstaller(interlock, (ITestStateManager)stateManager, stripeVerboseManager, stripeConfig);
        for (int i2 = 0; i2 < stripeSize; ++i2) {
            String serverName = (String)stripeConfig.getServerNames().get(i2);
            Path serverWorkingDir = stripeInstallationDir.resolve(serverName);
            Path tcConfigRelative = this.relativize(serverWorkingDir, tcConfig);
            Path kitLocationRelative = this.relativize(serverWorkingDir, harnessOptions.kitOriginPath);
            int debugPort = (Integer)stripeConfig.getServerDebugPorts().get(i2);
            StartupCommandBuilder builder = new DefaultStartupCommandBuilder().tcConfig(tcConfigRelative).serverName(serverName).stripeName(stripeName).serverWorkingDir(serverWorkingDir).kitDir(kitLocationRelative).logConfigExtension("logback-ext.xml").consistentStartup(false);
            stripeInstaller.installNewServer(serverName, serverWorkingDir, debugPort, builder::build);
        }
        ReadyStripe oneStripe = ReadyStripe.configureAndStartStripe((StateInterlock)interlock, (VerboseManager)verboseManager, (StripeConfiguration)stripeConfig, (StripeInstaller)stripeInstaller);
        IMultiProcessControl processControl = oneStripe.getStripeControl();
        String connectUri = oneStripe.getStripeUri();
        ClusterInfo clusterInfo = oneStripe.getClusterInfo();
        Assert.assertTrue((null != processControl ? 1 : 0) != 0);
        Assert.assertTrue((null != connectUri ? 1 : 0) != 0);
        BasicClientArgumentBuilder argBuilder = new BasicClientArgumentBuilder(harnessOptions.testClassName, harnessOptions.errorClassName);
        ClientsConfiguration clientsConfiguration = new ClientsConfiguration(harnessOptions.configTestDir, harnessOptions.clientClassPath, harnessOptions.clientsToCreate, (IClientArgumentBuilder)argBuilder, connectUri, 1, stripeSize, debugOptions.setupClientDebugPort, debugOptions.destroyClientDebugPort, debugOptions.testClientDebugPortStart, harnessOptions.failOnLog, clusterInfo);
        VerboseManager clientsVerboseManager = verboseManager.createComponentManager("[Clients]");
        new ClientSubProcessManager((IGalvanStateInterlock)interlock, (ITestStateManager)stateManager, clientsVerboseManager, clientsConfiguration, processControl).start();
        try {
            stateManager.waitForFinish();
        }
        finally {
            try {
                interlock.forceShutdown();
            }
            finally {
                serverPortRefs.forEach(PortManager.PortRef::close);
                groupPortRefs.forEach(PortManager.PortRef::close);
                debugPortRefs.stream().filter(Objects::nonNull).forEach(PortManager.PortRef::close);
            }
        }
    }

    private Path relativize(Path root, Path other) {
        return root.toAbsolutePath().relativize(other.toAbsolutePath());
    }

    private Path createTcConfig(List<String> serverNames, List<Integer> serverPorts, List<Integer> serverGroupPorts, Path stripeInstallationDir, AbstractHarnessEntry.CommonHarnessOptions harnessOpts) {
        TcConfigBuilder configBuilder = new TcConfigBuilder(stripeInstallationDir, serverNames, serverPorts, serverGroupPorts, harnessOpts.tcProperties, harnessOpts.namespaceFragment, harnessOpts.serviceFragment, harnessOpts.clientReconnectWindow, harnessOpts.voterCount);
        String tcConfig = configBuilder.build();
        try {
            Path tcConfigPath = Files.createFile(stripeInstallationDir.resolve("tc-config.xml"), new FileAttribute[0]);
            Files.write(tcConfigPath, tcConfig.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            return tcConfigPath;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

