/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.testing.config;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Supplier;

public class TcConfigBuilder {
    private final Function<String, String> logPath;
    private final Supplier<String> serviceFragment;
    private final List<String> serverNames;
    private final List<Integer> serverPorts;
    private final List<Integer> serverGroupPorts;
    private final String namespaceFragment;
    private final int clientReconnectWindow;
    private final int voterCount;
    private final Properties tcProperties = new Properties();

    public TcConfigBuilder(Path stripePath, List<String> serverNames, List<Integer> serverPorts, List<Integer> serverGroupPorts, Properties tcProperties, String namespaceFragment, String serviceFragment, int clientReconnectWindow, int voterCount) {
        this((String name) -> stripePath != null ? stripePath.resolve((String)name).resolve("logs").toAbsolutePath().toString() : Paths.get(name, new String[0]).resolve("logs").toString(), () -> serviceFragment == null ? "" : serviceFragment, serverNames, serverPorts, serverGroupPorts, tcProperties, namespaceFragment, clientReconnectWindow, voterCount);
    }

    public TcConfigBuilder(Function<String, String> serverLogs, Supplier<String> serviceFragment, List<String> serverNames, List<Integer> serverPorts, List<Integer> serverGroupPorts, Properties tcProperties, String namespaceFragment, int clientReconnectWindow, int voterCount) {
        this.logPath = serverLogs;
        this.serverNames = serverNames;
        this.serverPorts = serverPorts;
        this.serverGroupPorts = serverGroupPorts;
        this.tcProperties.putAll((Map<?, ?>)tcProperties);
        this.namespaceFragment = namespaceFragment;
        this.serviceFragment = serviceFragment;
        this.clientReconnectWindow = clientReconnectWindow;
        this.voterCount = voterCount;
    }

    public String build() {
        String namespaces = null != this.namespaceFragment ? this.namespaceFragment : "";
        String pre = "<tc-config xmlns=\"http://www.terracotta.org/config\" " + namespaces + ">\n  <plugins>\n";
        String services = this.serviceFragment.get();
        String postservices = "  </plugins>\n  <tc-properties>\n";
        StringBuilder properties = new StringBuilder();
        for (Map.Entry<Object, Object> entry : this.tcProperties.entrySet()) {
            properties.append("    <property name=\"").append(entry.getKey()).append("\" value=\"").append(entry.getValue()).append("\"/>\n");
        }
        String postProperties = "  </tc-properties>\n  <servers>\n";
        StringBuilder servers = new StringBuilder();
        for (int i = 0; i < this.serverNames.size(); ++i) {
            String serverName = this.serverNames.get(i);
            Integer port = this.serverPorts.get(i);
            Integer groupPort = this.serverGroupPorts.get(i);
            String oneServer = "    <server host=\"localhost\" name=\"" + serverName + "\">\n      <logs>" + this.logPath.apply(serverName) + "</logs>\n      <tsa-port>" + port + "</tsa-port>\n      <tsa-group-port>" + groupPort + "</tsa-group-port>\n    </server>\n";
            servers.append(oneServer);
        }
        String post = "    <client-reconnect-window>" + this.clientReconnectWindow + "</client-reconnect-window>\n  </servers>\n  <failover-priority>\n" + (this.voterCount == -1 ? "    <availability/>\n" : "    <consistency>\n      <voter count=\"" + this.voterCount + "\"/>\n    </consistency>\n") + "  </failover-priority>\n</tc-config>\n";
        return pre + services + postservices + properties + postProperties + servers + post;
    }
}

