/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.testing.config;

import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import org.terracotta.testing.config.StartupCommandBuilder;
import org.terracotta.testing.demos.TestHelpers;

public class DefaultStartupCommandBuilder
implements StartupCommandBuilder {
    private Path tcConfig;
    private Path kitDir;
    private Path serverWorkingDir;
    private String logConfigExt;
    private String serverName;
    private boolean consistentStartup;
    private String[] builtCommand;

    @Override
    public StartupCommandBuilder tcConfig(Path tcConfig) {
        this.tcConfig = tcConfig;
        return this;
    }

    @Override
    public StartupCommandBuilder serverWorkingDir(Path serverWorkingDir) {
        this.serverWorkingDir = serverWorkingDir;
        return this;
    }

    @Override
    public StartupCommandBuilder serverName(String serverName) {
        this.serverName = serverName;
        return this;
    }

    @Override
    public StartupCommandBuilder stripeName(String stripeName) {
        return this;
    }

    @Override
    public StartupCommandBuilder consistentStartup(boolean consistentStartup) {
        this.consistentStartup = consistentStartup;
        return this;
    }

    @Override
    public StartupCommandBuilder kitDir(Path kitDir) {
        this.kitDir = kitDir;
        return this;
    }

    @Override
    public StartupCommandBuilder logConfigExtension(String logConfigExt) {
        this.logConfigExt = logConfigExt;
        return this;
    }

    protected void installServer() throws IOException {
        InputStream logExt;
        Files.createDirectories(this.serverWorkingDir, new FileAttribute[0]);
        Files.copy(this.getClass().getResourceAsStream("/tc-logback.xml"), this.serverWorkingDir.resolve("logback-test.xml"), StandardCopyOption.REPLACE_EXISTING);
        Properties props = new Properties();
        props.setProperty("serverWorkingDir", this.serverWorkingDir.toAbsolutePath().toString());
        props.store(new FileWriter(this.serverWorkingDir.resolve("logbackVars.properties").toFile()), "logging variables");
        if (this.logConfigExt != null && (logExt = this.getClass().getResourceAsStream("/" + this.logConfigExt)) != null) {
            Files.copy(logExt, this.serverWorkingDir.resolve("logback-ext-test.xml"), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    protected String getAbsolutePath(Path scriptPath) {
        Path basePath = this.getServerWorkingDir().resolve(this.getKitDir()).resolve(scriptPath).toAbsolutePath().normalize();
        return TestHelpers.isWindows() ? "\"" + basePath + ".bat\"" : basePath + ".sh";
    }

    @Override
    public String[] build() {
        if (this.builtCommand == null) {
            try {
                this.installServer();
                String startScript = this.getAbsolutePath(Paths.get("server", "bin", "start-tc-server"));
                this.builtCommand = new String[]{startScript, "-f", this.tcConfig.toString(), "-n", this.serverName, "JAVA_OPTS=-Dlogback.configurationFile=logback-test.xml"};
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.builtCommand;
    }

    public Path getTcConfig() {
        return this.tcConfig;
    }

    public Path getKitDir() {
        return this.kitDir;
    }

    public Path getServerWorkingDir() {
        return this.serverWorkingDir;
    }

    public String getLogConfigExt() {
        return this.logConfigExt;
    }

    public String getServerName() {
        return this.serverName;
    }

    public boolean isConsistentStartup() {
        return this.consistentStartup;
    }
}

