/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util;

import com.tc.util.Assert;
import com.tc.util.Conversion;

public class OidLongArray {
    public static final int BYTES_PER_LONG = 8;
    public static final int BITS_PER_LONG = 64;
    private long key;
    private long[] ary;

    public OidLongArray(int size, long key) {
        this.ary = new long[size];
        this.key = key;
    }

    public OidLongArray(byte[] key, byte[] value) {
        if (key == null || value == null) {
            this.ary = null;
            return;
        }
        this.key = Conversion.bytes2Long((byte[])key);
        this.ary = this.valueToArray(value);
    }

    public OidLongArray(long key, byte[] value) {
        if (value == null) {
            this.ary = null;
            return;
        }
        this.key = key;
        this.ary = this.valueToArray(value);
    }

    private long[] valueToArray(byte[] value) {
        long[] lary = new long[value.length / 8];
        for (int i = 0; i < lary.length; ++i) {
            lary[i] = Conversion.bytes2Long((byte[])value, (int)(i * 8));
        }
        return lary;
    }

    private long bit(int bitIndex) {
        Assert.assertTrue((Object)"Bit index out of range", (bitIndex >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((Object)"Bit index out of range", (bitIndex < 64 ? 1 : 0) != 0);
        return 1L << bitIndex;
    }

    public void setKey(long key) {
        this.key = key;
    }

    public long getKey() {
        return this.key;
    }

    public long[] getArray() {
        return this.ary;
    }

    public byte[] keyToBytes() {
        return this.keyToBytes(0);
    }

    public byte[] keyToBytes(int auxKey) {
        return Conversion.long2Bytes((long)(this.key + (long)auxKey));
    }

    public byte[] arrayToBytes() {
        byte[] data = new byte[this.length() * 8];
        for (int i = 0; i < this.length(); ++i) {
            Conversion.writeLong((long)this.ary[i], (byte[])data, (int)(i * 8));
        }
        return data;
    }

    public void copyOut(OidLongArray dest, int offset) {
        for (int i = 0; i < dest.length(); ++i) {
            dest.set(i, this.ary[offset + i]);
        }
    }

    public void applyIn(OidLongArray src, int offset) {
        for (int i = 0; i < src.length(); ++i) {
            int n = i + offset;
            this.ary[n] = this.ary[n] | src.get(i);
        }
    }

    public boolean isZero() {
        for (int i = 0; i < this.length(); ++i) {
            if (this.ary[i] == 0L) continue;
            return false;
        }
        return true;
    }

    public boolean isEnded() {
        return this.ary == null;
    }

    public long get(int index) {
        return this.ary[index];
    }

    public void set(int index, long val) {
        this.ary[index] = val;
    }

    public int length() {
        return this.ary.length;
    }

    public long setBit(int bit) {
        int byteIndex = bit / 64;
        int bitIndex = bit % 64;
        int n = byteIndex;
        this.ary[n] = this.ary[n] | this.bit(bitIndex);
        return this.ary[byteIndex];
    }

    public long clrBit(int bit) {
        int byteIndex = bit / 64;
        int bitIndex = bit % 64;
        int n = byteIndex;
        this.ary[n] = this.ary[n] & (this.bit(bitIndex) ^ 0xFFFFFFFFFFFFFFFFL);
        return this.ary[byteIndex];
    }

    public boolean isSet(int bit) {
        int byteIndex = bit / 64;
        int bitIndex = bit % 64;
        return (this.ary[byteIndex] & this.bit(bitIndex)) != 0L;
    }

    public int totalBits() {
        return this.ary.length * 64;
    }
}

