/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.net.core.TCConnection;
import com.tc.net.core.TCConnectionManager;
import com.tc.net.protocol.transport.ConnectionHealthChecker;
import com.tc.net.protocol.transport.ConnectionHealthCheckerContext;
import com.tc.net.protocol.transport.ConnectionHealthCheckerContextImpl;
import com.tc.net.protocol.transport.ConnectionID;
import com.tc.net.protocol.transport.HealthCheckerConfig;
import com.tc.net.protocol.transport.MessageTransport;
import com.tc.net.protocol.transport.MessageTransportBase;
import com.tc.util.Assert;
import com.tc.util.concurrent.SetOnceFlag;
import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionHealthCheckerImpl
implements ConnectionHealthChecker {
    private final Logger logger;
    private final Timer monitorThread;
    private final HealthCheckerMonitorThreadEngine monitorThreadEngine;
    private final SetOnceFlag shutdown = new SetOnceFlag();
    private final SetOnceFlag started = new SetOnceFlag();

    public ConnectionHealthCheckerImpl(HealthCheckerConfig healthCheckerConfig, TCConnectionManager connManager) {
        Assert.assertNotNull((Object)healthCheckerConfig);
        Assert.eval((boolean)healthCheckerConfig.isHealthCheckerEnabled());
        this.logger = LoggerFactory.getLogger((String)(ConnectionHealthCheckerImpl.class.getName() + ": " + healthCheckerConfig.getHealthCheckerName()));
        this.monitorThread = new Timer(healthCheckerConfig.getHealthCheckerName() + " - HealthCheck-Timer", true);
        this.monitorThreadEngine = this.getHealthMonitorThreadEngine(healthCheckerConfig, connManager, this.logger);
    }

    protected HealthCheckerMonitorThreadEngine getHealthMonitorThreadEngine(HealthCheckerConfig config, TCConnectionManager connectionManager, Logger loger) {
        return new HealthCheckerMonitorThreadEngine(config, connectionManager, loger);
    }

    @Override
    public void start() {
        if (this.started.attemptSet() && !this.shutdown.isSet()) {
            try {
                this.monitorThread.scheduleAtFixedRate((TimerTask)this.monitorThreadEngine, 0L, this.monitorThreadEngine.pingInterval);
            }
            catch (IllegalStateException state) {
                this.logger.warn("HealthChecker cannot start");
                return;
            }
            this.logger.info("HealthChecker Started");
        } else {
            this.logger.warn("HealthChecker already started");
        }
    }

    @Override
    public void stop() {
        if (this.shutdown.attemptSet()) {
            this.monitorThreadEngine.stop();
            this.monitorThread.cancel();
            this.logger.debug("HealthChecker STOP requested");
        } else {
            this.logger.warn("HealthChecker STOP already requested");
        }
    }

    public boolean isRunning() {
        return this.started.isSet() && !this.shutdown.isSet();
    }

    @Override
    public void notifyTransportClosed(MessageTransport transport) {
        if (this.monitorThreadEngine.removeConnection(transport)) {
            InetSocketAddress remoteAddress = transport.getRemoteAddress();
            if (remoteAddress != null) {
                this.logger.info("Connection to [" + remoteAddress.toString() + "] CLOSED. Health Monitoring for this node is now disabled.");
            } else {
                this.logger.info("Connection " + transport.getConnectionID() + " CLOSED. Health Monitor for this node is disabled.");
            }
        }
    }

    @Override
    public void notifyTransportConnectAttempt(MessageTransport transport) {
    }

    @Override
    public void notifyTransportConnected(MessageTransport transport) {
        this.monitorThreadEngine.addConnection(transport);
    }

    @Override
    public void notifyTransportDisconnected(MessageTransport transport, boolean forcedDisconnect) {
        if (this.monitorThreadEngine.removeConnection(transport)) {
            InetSocketAddress remoteAddress = transport.getRemoteAddress();
            if (remoteAddress != null) {
                this.logger.info("Connection to [" + remoteAddress.toString() + "] DISCONNECTED. Health Monitoring for this node is now disabled.");
            } else {
                this.logger.info("Connection " + transport.getConnectionID() + " DISCONNECTED. Health Monitor for this node is disabled.");
            }
        }
    }

    @Override
    public void notifyTransportReconnectionRejected(MessageTransport transport) {
    }

    public int getTotalConnsUnderMonitor() {
        return this.monitorThreadEngine.getTotalConnectionsUnderMonitor();
    }

    public long getTotalProbesSentOnAllConns() {
        return this.monitorThreadEngine.getTotalProbesSentOnAllConnections();
    }

    static class HealthCheckerMonitorThreadEngine
    extends TimerTask {
        private final ConcurrentMap<ConnectionID, MessageTransportBase> connectionMap = new ConcurrentHashMap<ConnectionID, MessageTransportBase>();
        private final long pingIdleTime;
        private final long pingInterval;
        private final int pingProbes;
        private final long checkTimeInterval;
        private final SetOnceFlag stop = new SetOnceFlag();
        private final HealthCheckerConfig config;
        private final Logger logger;
        private final TCConnectionManager connectionManager;
        private final AtomicLong lastCheckTime = new AtomicLong(System.currentTimeMillis());

        public HealthCheckerMonitorThreadEngine(HealthCheckerConfig healthCheckerConfig, TCConnectionManager connectionManager, Logger logger) {
            this.pingIdleTime = healthCheckerConfig.getPingIdleTimeMillis();
            this.pingInterval = healthCheckerConfig.getPingIntervalMillis();
            this.pingProbes = healthCheckerConfig.getPingProbes();
            this.checkTimeInterval = healthCheckerConfig.getCheckTimeInterval();
            this.connectionManager = connectionManager;
            this.config = healthCheckerConfig;
            Assert.assertNotNull((Object)logger);
            this.logger = logger;
            if (this.pingIdleTime - this.pingInterval < 0L || this.pingIdleTime <= 0L || this.pingInterval <= 0L || this.pingProbes <= 0) {
                logger.info("ping_interval period should be less than ping_idletime and ping Ideltime/Interval/Probes cannot be 0 or negative.");
                logger.info("Disabling HealthChecker for this CommsMgr");
                throw new AssertionError((Object)"HealthChecker Config Error");
            }
        }

        private void addConnection(MessageTransport transport) {
            MessageTransportBase mtb = (MessageTransportBase)transport;
            mtb.setHealthCheckerContext(this.getHealthCheckerContext(mtb, this.config, this.connectionManager));
            this.connectionMap.put(transport.getConnectionID(), mtb);
        }

        private boolean removeConnection(MessageTransport transport) {
            return this.connectionMap.remove(transport.getConnectionID()) != null;
        }

        protected ConnectionHealthCheckerContext getHealthCheckerContext(MessageTransportBase transport, HealthCheckerConfig conf, TCConnectionManager connManager) {
            return new ConnectionHealthCheckerContextImpl(transport, conf, connManager);
        }

        public void stop() {
            this.stop.attemptSet();
            this.cancel();
        }

        @Override
        public void run() {
            boolean canCheckTime = this.canCheckTime();
            Iterator connectionIterator = this.connectionMap.values().iterator();
            while (connectionIterator.hasNext()) {
                MessageTransportBase mtb = (MessageTransportBase)connectionIterator.next();
                TCConnection conn = mtb.getConnection();
                if (conn == null || !mtb.isConnected()) {
                    this.logger.info("[" + (conn == null ? null : conn.getRemoteAddress().toString()) + "] is not connected. Health Monitoring for this node is now disabled.");
                    connectionIterator.remove();
                    continue;
                }
                if (mtb.getReceiveLayer() == null) {
                    this.logger.info("[" + (conn == null ? null : conn.getRemoteAddress().toString()) + "] is no longer referenced.  Closing the connection");
                    mtb.disconnect();
                    connectionIterator.remove();
                    continue;
                }
                ConnectionHealthCheckerContext connContext = mtb.getHealthCheckerContext();
                if (conn.getIdleReceiveTime() >= this.pingIdleTime) {
                    if (!connContext.probeIfAlive()) {
                        this.logger.error("Declared connection dead " + mtb.getConnectionID() + " idle time " + conn.getIdleReceiveTime() + "ms");
                        mtb.disconnect();
                        connectionIterator.remove();
                    }
                } else {
                    connContext.refresh();
                }
                if (!canCheckTime) continue;
                connContext.checkTime();
            }
            if (canCheckTime) {
                this.lastCheckTime.set(System.currentTimeMillis());
            }
        }

        boolean canCheckTime() {
            return this.config.isCheckTimeEnabled() && System.currentTimeMillis() - this.lastCheckTime.get() >= this.checkTimeInterval;
        }

        int getTotalConnectionsUnderMonitor() {
            return this.connectionMap.size();
        }

        long getTotalProbesSentOnAllConnections() {
            Iterator connIterator = this.connectionMap.values().iterator();
            long totalProbeSent = 0L;
            while (connIterator.hasNext()) {
                MessageTransportBase mtb = (MessageTransportBase)connIterator.next();
                ConnectionHealthCheckerContextImpl connContext = (ConnectionHealthCheckerContextImpl)mtb.getHealthCheckerContext();
                totalProbeSent += connContext.getTotalProbesSent();
            }
            return totalProbeSent;
        }
    }
}

