/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.core;

import com.tc.net.core.AbstractBufferManager;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClearTextBufferManager
extends AbstractBufferManager {
    private static final Logger logger = LoggerFactory.getLogger(ClearTextBufferManager.class);
    private static final String BUFFER_SIZE = "clear.text.buffer.size";
    static final int BUFFER_SIZE_KB = Integer.getInteger("clear.text.buffer.size", 16) * 1024;
    private final SocketChannel channel;
    private final ByteBuffer sendBuffer;
    private final ByteBuffer recvBuffer;

    public ClearTextBufferManager(SocketChannel channel) {
        this(channel, ByteBuffer.allocate(BUFFER_SIZE_KB), ByteBuffer.allocate(BUFFER_SIZE_KB));
    }

    protected ClearTextBufferManager(SocketChannel channel, ByteBuffer send, ByteBuffer recv) {
        this.channel = channel;
        if (logger.isDebugEnabled()) {
            logger.debug(((Object)((Object)this)).getClass().getName() + " " + BUFFER_SIZE + " " + BUFFER_SIZE_KB);
        }
        this.sendBuffer = send;
        this.recvBuffer = recv;
    }

    public int sendFromBuffer() throws IOException {
        this.sendBuffer.flip();
        int written = this.channel.write(this.sendBuffer);
        this.sendBuffer.compact();
        if (written == -1) {
            throw new EOFException();
        }
        return written;
    }

    public int recvToBuffer() throws IOException {
        int read = this.channel.read(this.getRecvBuffer());
        if (read == -1) {
            throw new EOFException();
        }
        return read;
    }

    public void close() {
    }

    protected ByteBuffer getRecvBuffer() {
        return this.recvBuffer;
    }

    protected ByteBuffer getSendBuffer() {
        return this.sendBuffer;
    }
}

