/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.core;

import com.tc.bytes.TCByteBuffer;
import com.tc.bytes.TCDirectByteBufferCache;
import com.tc.net.core.BufferManager;
import com.tc.net.core.BufferManagerFactory;
import com.tc.net.core.CachingClearTextBufferManager;
import com.tc.net.core.ClearTextBufferManager;
import com.tc.text.PrettyPrintable;
import java.nio.channels.SocketChannel;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;

public class CachingClearTextBufferManagerFactory
implements BufferManagerFactory,
PrettyPrintable {
    private final TCDirectByteBufferCache buffers = new TCDirectByteBufferCache(ClearTextBufferManager.BUFFER_SIZE_KB);

    public BufferManager createBufferManager(SocketChannel socketChannel, boolean client) {
        TCByteBuffer send = this.buffers.poll();
        TCByteBuffer recv = this.buffers.poll();
        return new CachingClearTextBufferManager(socketChannel, send, recv, (Queue<TCByteBuffer>)this.buffers);
    }

    public Map<String, ?> getStateMap() {
        LinkedHashMap<String, Object> state = new LinkedHashMap<String, Object>();
        state.put("type", this.getClass().getName());
        state.put("pool.size", this.buffers.size());
        state.put("pool.referenced", this.buffers.referenced());
        return state;
    }
}

