/*
 * Decompiled with CFR 0.152.
 */
package com.tc.logging;

import com.tc.util.Assert;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class LossyTCLogger
implements Logger {
    public static final long DEFAULT_LOG_TIME_INTERVAL = 5000L;
    private final Logger logger;
    private final String lossyInfo;
    private LogOrNot decider;
    private long logCount = 0L;

    public LossyTCLogger(Logger logger) {
        this(logger, 5000L);
    }

    public LossyTCLogger(Logger logger, long logInterval) {
        this(logger, logInterval, LossyTCLoggerType.TIME_BASED);
    }

    public LossyTCLogger(Logger logger, long logInterval, LossyTCLoggerType type) {
        this(logger, logInterval, type, false);
    }

    public LossyTCLogger(Logger logger, long logInterval, LossyTCLoggerType type, boolean lossyLogOnlyIfSameContent) {
        Assert.eval((logInterval > 0L ? 1 : 0) != 0);
        this.logger = logger;
        this.decider = type == LossyTCLoggerType.TIME_BASED ? new TimeBasedDecider(logInterval, lossyLogOnlyIfSameContent) : new CountBasedDecider(logInterval, lossyLogOnlyIfSameContent);
        this.lossyInfo = " [lossy interval: " + logInterval + (type == LossyTCLoggerType.TIME_BASED ? "ms]" : "]");
        this.logCount = 0L;
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void debug(String s) {
        if (this.decider.canLog(s)) {
            this.logger.debug(s + this.lossyInfo);
        }
    }

    public void debug(String s, Object o) {
        if (this.decider.canLog(s)) {
            this.logger.debug(s + this.lossyInfo, o);
        }
    }

    public void debug(String s, Object o, Object o1) {
        if (this.decider.canLog(s)) {
            this.logger.debug(s + this.lossyInfo, o, o1);
        }
    }

    public void debug(String s, Object ... objects) {
        if (this.decider.canLog(s)) {
            this.logger.debug(s + this.lossyInfo, objects);
        }
    }

    public void debug(String s, Throwable throwable) {
        if (this.decider.canLog(s)) {
            this.logger.debug(s + this.lossyInfo, throwable);
        }
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.logger.isDebugEnabled(marker);
    }

    public void debug(Marker marker, String s) {
        if (this.decider.canLog(s)) {
            this.logger.debug(marker, s + this.lossyInfo);
        }
    }

    public void debug(Marker marker, String s, Object o) {
        if (this.decider.canLog(s)) {
            this.logger.debug(marker, s + this.lossyInfo, o);
        }
    }

    public void debug(Marker marker, String s, Object o, Object o1) {
        if (this.decider.canLog(s)) {
            this.logger.debug(marker, s + this.lossyInfo, o, o1);
        }
    }

    public void debug(Marker marker, String s, Object ... objects) {
        if (this.decider.canLog(s)) {
            this.logger.debug(marker, s + this.lossyInfo, objects);
        }
    }

    public void debug(Marker marker, String s, Throwable throwable) {
        if (this.decider.canLog(s)) {
            this.logger.debug(marker, s + this.lossyInfo, throwable);
        }
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void info(String s) {
        if (this.decider.canLog(s)) {
            this.logger.info(s + this.lossyInfo);
        }
    }

    public void info(String s, Object o) {
        if (this.decider.canLog(s)) {
            this.logger.info(s + this.lossyInfo, o);
        }
    }

    public void info(String s, Object o, Object o1) {
        if (this.decider.canLog(s)) {
            this.logger.info(s + this.lossyInfo, o, o1);
        }
    }

    public void info(String s, Object ... objects) {
        if (this.decider.canLog(s)) {
            this.logger.info(s + this.lossyInfo, objects);
        }
    }

    public void info(String s, Throwable throwable) {
        if (this.decider.canLog(s)) {
            this.logger.info(s + this.lossyInfo, throwable);
        }
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.logger.isInfoEnabled(marker);
    }

    public void info(Marker marker, String s) {
        if (this.decider.canLog(s)) {
            this.logger.info(marker, s + this.lossyInfo);
        }
    }

    public void info(Marker marker, String s, Object o) {
        if (this.decider.canLog(s)) {
            this.logger.info(marker, s + this.lossyInfo, o);
        }
    }

    public void info(Marker marker, String s, Object o, Object o1) {
        if (this.decider.canLog(s)) {
            this.logger.info(marker, s + this.lossyInfo, o, o1);
        }
    }

    public void info(Marker marker, String s, Object ... objects) {
        if (this.decider.canLog(s)) {
            this.logger.info(marker, s + this.lossyInfo, objects);
        }
    }

    public void info(Marker marker, String s, Throwable throwable) {
        if (this.decider.canLog(s)) {
            this.logger.info(marker, s + this.lossyInfo, throwable);
        }
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public void warn(String s) {
        if (this.decider.canLog(s)) {
            this.logger.warn(s + this.lossyInfo);
        }
    }

    public void warn(String s, Object o) {
        if (this.decider.canLog(s)) {
            this.logger.warn(s + this.lossyInfo, o);
        }
    }

    public void warn(String s, Object ... objects) {
        if (this.decider.canLog(s)) {
            this.logger.warn(s + this.lossyInfo, objects);
        }
    }

    public void warn(String s, Object o, Object o1) {
        if (this.decider.canLog(s)) {
            this.logger.warn(s + this.lossyInfo, o, o1);
        }
    }

    public void warn(String s, Throwable throwable) {
        if (this.decider.canLog(s)) {
            this.logger.warn(s + this.lossyInfo, throwable);
        }
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.logger.isWarnEnabled(marker);
    }

    public void warn(Marker marker, String s) {
        if (this.decider.canLog(s)) {
            this.logger.warn(marker, s + this.lossyInfo);
        }
    }

    public void warn(Marker marker, String s, Object o) {
        if (this.decider.canLog(s)) {
            this.logger.warn(marker, s + this.lossyInfo, o);
        }
    }

    public void warn(Marker marker, String s, Object o, Object o1) {
        if (this.decider.canLog(s)) {
            this.logger.warn(marker, s + this.lossyInfo, o, o1);
        }
    }

    public void warn(Marker marker, String s, Object ... objects) {
        if (this.decider.canLog(s)) {
            this.logger.warn(marker, s + this.lossyInfo, objects);
        }
    }

    public void warn(Marker marker, String s, Throwable throwable) {
        if (this.decider.canLog(s)) {
            this.logger.warn(marker, s + this.lossyInfo, throwable);
        }
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public void error(String s) {
        this.logger.error(s);
    }

    public void error(String s, Object o) {
        this.logger.error(s, o);
    }

    public void error(String s, Object o, Object o1) {
        this.logger.error(s, o, o1);
    }

    public void error(String s, Object ... objects) {
        this.logger.error(s, objects);
    }

    public void error(String s, Throwable throwable) {
        this.logger.error(s, throwable);
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.logger.isErrorEnabled(marker);
    }

    public void error(Marker marker, String s) {
        this.logger.error(marker, s);
    }

    public void error(Marker marker, String s, Object o) {
        this.logger.error(marker, s, o);
    }

    public void error(Marker marker, String s, Object o, Object o1) {
        this.logger.error(marker, s, o, o1);
    }

    public void error(Marker marker, String s, Object ... objects) {
        this.logger.error(marker, s, objects);
    }

    public void error(Marker marker, String s, Throwable throwable) {
        this.logger.error(marker, s, throwable);
    }

    public String getName() {
        return this.logger.getName();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public void trace(String s) {
        if (this.decider.canLog(s)) {
            this.logger.trace(s + this.lossyInfo);
        }
    }

    public void trace(String s, Object o) {
        if (this.decider.canLog(s)) {
            this.logger.trace(s + this.lossyInfo, o);
        }
    }

    public void trace(String s, Object o, Object o1) {
        if (this.decider.canLog(s)) {
            this.logger.trace(s + this.lossyInfo, o, o1);
        }
    }

    public void trace(String s, Object ... objects) {
        if (this.decider.canLog(s)) {
            this.logger.trace(s + this.lossyInfo, objects);
        }
    }

    public void trace(String s, Throwable throwable) {
        if (this.decider.canLog(s)) {
            this.logger.trace(s + this.lossyInfo, throwable);
        }
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.logger.isTraceEnabled(marker);
    }

    public void trace(Marker marker, String s) {
        if (this.decider.canLog(s)) {
            this.logger.trace(marker, s + this.lossyInfo);
        }
    }

    public void trace(Marker marker, String s, Object o) {
        if (this.decider.canLog(s)) {
            this.logger.trace(marker, s + this.lossyInfo, o);
        }
    }

    public void trace(Marker marker, String s, Object o, Object o1) {
        if (this.decider.canLog(s)) {
            this.logger.trace(marker, s + this.lossyInfo, o, o1);
        }
    }

    public void trace(Marker marker, String s, Object ... objects) {
        if (this.decider.canLog(s)) {
            this.logger.trace(marker, s + this.lossyInfo, objects);
        }
    }

    public void trace(Marker marker, String s, Throwable throwable) {
        if (this.decider.canLog(s)) {
            this.logger.trace(marker, s + this.lossyInfo, throwable);
        }
    }

    public boolean isLoggingEnabledNow() {
        return this.decider.isLoggingEnabledNow();
    }

    private synchronized void updateLogCount() {
        ++this.logCount;
    }

    synchronized long getLogCount() {
        return this.logCount;
    }

    private class CountBasedDecider
    implements LogOrNot {
        private final long countInterval;
        private final boolean lossyLogOnlyIfSameContent;
        private Object prevMessage = null;
        private long count;

        CountBasedDecider(long logInterval, boolean lossyLogOnlyIfSameContent) {
            this.countInterval = logInterval;
            this.lossyLogOnlyIfSameContent = lossyLogOnlyIfSameContent;
            this.count = 0L;
        }

        @Override
        public synchronized boolean canLog(Object message) {
            if (this.lossyLogOnlyIfSameContent && (this.prevMessage == null || !this.prevMessage.equals(message))) {
                this.prevMessage = message;
                this.count = 1L;
                LossyTCLogger.this.updateLogCount();
                return true;
            }
            this.prevMessage = message;
            if (this.count++ % this.countInterval == 0L) {
                this.count %= this.countInterval;
                LossyTCLogger.this.updateLogCount();
                return true;
            }
            return false;
        }

        @Override
        public boolean isLoggingEnabledNow() {
            long remainder = this.count % this.countInterval;
            if (remainder != 0L) {
                ++this.count;
                return false;
            }
            return true;
        }
    }

    private class TimeBasedDecider
    implements LogOrNot {
        private final long timeInterval;
        private final boolean lossyLogOnlyIfSameContent;
        private long then;
        private Object prevMessage = null;

        TimeBasedDecider(long logInterval, boolean lossyLogOnlyIfSameContent) {
            this.timeInterval = logInterval;
            this.lossyLogOnlyIfSameContent = lossyLogOnlyIfSameContent;
        }

        @Override
        public synchronized boolean canLog(Object message) {
            long now = System.currentTimeMillis();
            if (this.lossyLogOnlyIfSameContent && (this.prevMessage == null || !this.prevMessage.equals(message))) {
                this.prevMessage = message;
                this.then = System.currentTimeMillis();
                LossyTCLogger.this.updateLogCount();
                return true;
            }
            this.prevMessage = message;
            if (now > this.then + this.timeInterval) {
                this.then = now;
                LossyTCLogger.this.updateLogCount();
                return true;
            }
            return false;
        }

        @Override
        public boolean isLoggingEnabledNow() {
            return System.currentTimeMillis() > this.then + this.timeInterval;
        }
    }

    static interface LogOrNot {
        public boolean canLog(Object var1);

        public boolean isLoggingEnabledNow();
    }

    public static enum LossyTCLoggerType {
        TIME_BASED,
        COUNT_BASED;

    }
}

