/*
 * Decompiled with CFR 0.152.
 */
package com.tc.async.impl;

import com.tc.async.impl.Event;
import com.tc.async.impl.EventCreator;
import com.tc.async.impl.PipelineMonitor;
import com.tc.async.impl.PipelineMonitoringConsumer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.terracotta.tripwire.TripwireFactory;

public class MonitoringEventCreator<EC>
implements EventCreator<EC> {
    private final String name;
    private final EventCreator<EC> next;
    private static final ThreadLocal<PipelineMonitor> CURRENT = new ThreadLocal();
    private final LongAdder queueTime = new LongAdder();
    private final LongAdder runTime = new LongAdder();
    private final LongAdder queued = new LongAdder();
    private static PipelineMonitoringConsumer pipelineConsumer;

    public MonitoringEventCreator(String name, EventCreator<EC> next) {
        this.name = name;
        this.next = next;
    }

    public static void setPipelineMonitor(PipelineMonitoringConsumer consumer) {
        pipelineConsumer = consumer;
    }

    public static void finish() {
        PipelineMonitor mon;
        if (pipelineConsumer != null && (mon = CURRENT.get()) != null) {
            mon.close();
            CURRENT.remove();
            pipelineConsumer.record(mon);
        }
    }

    public static void start() {
        if (pipelineConsumer != null) {
            CURRENT.set(new PipelineMonitor());
        }
    }

    @Override
    public Event createEvent(EC event) {
        Event nextEvent;
        MonitorStats stats = new MonitorStats(this.name, event.toString());
        PipelineMonitor running = CURRENT.get();
        if (running != null) {
            running.action(this.name, PipelineMonitor.Type.ENQUEUE, event);
        }
        if ((nextEvent = this.next.createEvent(event)) != null) {
            return () -> {
                if (running != null) {
                    CURRENT.set(running.action(this.name, PipelineMonitor.Type.RUN, event));
                }
                stats.run();
                nextEvent.call();
                stats.end();
                this.addStats(stats);
                if (running != null) {
                    CURRENT.remove();
                    running.action(this.name, PipelineMonitor.Type.END, event);
                }
            };
        }
        if (running != null) {
            running.action(this.name, PipelineMonitor.Type.RUN, event);
            running.action(this.name, PipelineMonitor.Type.END, event);
        }
        return null;
    }

    private void addStats(MonitorStats stats) {
        this.runTime.add(stats.runTime());
        this.queueTime.add(stats.queueTime());
        this.queued.increment();
    }

    public Map<String, ?> getState() {
        LinkedHashMap<String, Number> stats = new LinkedHashMap<String, Number>();
        stats.put("queueTime", this.queueTime);
        stats.put("runTime", this.runTime);
        stats.put("count", this.queued);
        long count = this.queued.sum();
        if (count > 0L) {
            stats.put("average queue time", TimeUnit.NANOSECONDS.toNanos(this.queueTime.sum() / count));
            stats.put("average run time", TimeUnit.NANOSECONDS.toNanos(this.runTime.sum() / count));
        }
        return stats;
    }

    private static class MonitorStats<EC> {
        private long queue = 0L;
        private long run = 0L;
        private long end = 0L;
        private final org.terracotta.tripwire.Event event;

        public MonitorStats(String name, String debugging) {
            this.queue();
            this.event = TripwireFactory.createStageEvent((String)name, (String)debugging);
        }

        void run() {
            this.run = System.nanoTime();
            this.event.begin();
        }

        final void queue() {
            this.queue = System.nanoTime();
        }

        void end() {
            this.end = System.nanoTime();
            this.event.end();
            this.event.commit();
        }

        long queueTime() {
            return this.run - this.queue;
        }

        long runTime() {
            return this.end - this.run;
        }
    }
}

