/*
 * Decompiled with CFR 0.152.
 */
package com.tc.async.impl;

import com.tc.async.api.EventHandlerException;
import com.tc.async.api.Sink;
import com.tc.async.api.Source;
import com.tc.async.impl.Event;
import com.tc.async.impl.EventCreator;
import com.tc.async.impl.MonitoringEventCreator;
import com.tc.async.impl.StageQueue;
import com.tc.logging.TCLoggerProvider;
import com.tc.util.Assert;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;

public abstract class AbstractStageQueueImpl<EC>
implements StageQueue<EC> {
    private volatile boolean closed = false;
    private volatile boolean extraStats = true;
    private volatile int maxDepth = 0;
    private final int queueSize;
    private final MonitoringEventCreator<EC> monitoring;
    private final EventCreator<EC> creator;
    final Logger logger;
    final String stageName;

    public AbstractStageQueueImpl(TCLoggerProvider loggerProvider, String stageName, EventCreator<EC> creator, int queueSize) {
        this.logger = loggerProvider.getLogger(Sink.class.getName() + ": " + stageName);
        this.stageName = stageName;
        this.creator = creator;
        this.monitoring = new MonitoringEventCreator<EC>(stageName, creator);
        this.queueSize = queueSize;
    }

    abstract SourceQueue[] getSources();

    @Override
    public void enableAdditionalStatistics(boolean track) {
        this.extraStats = track;
    }

    final Event createEvent(EC context) {
        return this.extraStats ? this.monitoring.createEvent(context) : this.creator.createEvent(context);
    }

    Logger getLogger() {
        return this.logger;
    }

    boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        Assert.assertFalse((boolean)this.closed);
        this.closed = true;
        for (SourceQueue q : this.getSources()) {
            try {
                q.put(new CloseEvent());
            }
            catch (InterruptedException ie) {
                this.logger.debug("closing stage", (Throwable)ie);
                Thread.currentThread().interrupt();
            }
        }
    }

    protected void updateDepth(int max) {
        if (max > this.maxDepth) {
            this.maxDepth = max;
        }
    }

    @Override
    public Map<String, ?> getState() {
        Map<String, ?> stats;
        LinkedHashMap<String, Object> queueState = new LinkedHashMap<String, Object>();
        if (this.extraStats && !(stats = this.monitoring.getState()).isEmpty()) {
            queueState.put("stats", stats);
            queueState.put("maxQueueDepth", this.maxDepth);
            queueState.put("queueSize", this.queueSize);
        }
        return queueState;
    }

    static class CloseEvent
    implements Event {
        @Override
        public void call() throws EventHandlerException {
        }
    }

    class HandledEvent<C>
    implements Event {
        private final Event event;

        public HandledEvent(Event event) {
            this.event = event;
        }

        @Override
        public void call() throws EventHandlerException {
            this.event.call();
        }
    }

    static interface SourceQueue
    extends Source {
        public int put(Event var1) throws InterruptedException;
    }
}

