/*
 * Decompiled with CFR 0.152.
 */
package com.tc.async.api;

import com.tc.async.api.AbstractEventHandler;
import com.tc.async.api.EventHandlerException;
import com.tc.async.api.PostInit;
import com.tc.async.api.Sink;
import java.util.Collection;
import java.util.function.Consumer;

public interface EventHandler<EC>
extends PostInit {
    public void handleEvent(EC var1) throws EventHandlerException;

    public void handleEvents(Collection<EC> var1) throws EventHandlerException;

    public void destroy();

    public static <EC> Sink<EC> directSink(EventHandler<EC> handler) {
        return e -> {
            try {
                handler.handleEvent(e);
            }
            catch (EventHandlerException ee) {
                throw new RuntimeException((Throwable)((Object)ee));
            }
        };
    }

    public static <EC> EventHandler<EC> consumer(final Consumer<EC> handler) {
        return new AbstractEventHandler<EC>(){

            @Override
            public void handleEvent(EC context) throws EventHandlerException {
                handler.accept(context);
            }
        };
    }
}

