/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.testing.config;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.terracotta.testing.config.ConfigFileStartupBuilder;
import org.terracotta.utilities.io.Files;

public class ConfigRepoStartupBuilder
extends ConfigFileStartupBuilder {
    private String[] builtCommand;

    @Override
    public String[] build() {
        if (this.builtCommand == null) {
            try {
                this.installServer();
                Path generatedRepositories = this.convertToConfigFile(false);
                Path source = generatedRepositories.resolve("stripe-" + this.getStripeId()).resolve(this.getServerName()).toAbsolutePath();
                Path destination = this.getServerWorkingDir().resolve("config").toAbsolutePath();
                Files.relocate((Path)source, (Path)destination, (CopyOption[])new CopyOption[0]);
                this.buildStartupCommand(destination);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return (String[])this.builtCommand.clone();
    }

    private void buildStartupCommand(Path destination) {
        ArrayList<String> command = new ArrayList<String>();
        String scriptPath = this.getAbsolutePath(Paths.get("server", "bin", "start-tc-server"));
        command.add(scriptPath);
        if (this.isConsistentStartup()) {
            command.add("-c");
        }
        command.add("-r");
        command.add(destination.toAbsolutePath().toString());
        this.builtCommand = command.toArray(new String[0]);
    }
}

