/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.testing.config;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.terracotta.dynamic_config.cli.upgrade_tools.config_converter.ConfigConverterTool;
import org.terracotta.testing.config.AbstractStartupCommandBuilder;

public class ConfigFileStartupBuilder
extends AbstractStartupCommandBuilder {
    private String[] builtCommand;

    @Override
    public String[] build() {
        if (this.builtCommand == null) {
            try {
                this.installServer();
                Path configFile = this.convertToConfigFile(true).resolve("test.properties");
                this.configFileStartupCommand(configFile);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return (String[])this.builtCommand.clone();
    }

    private void configFileStartupCommand(Path configFile) {
        Path configDir;
        ArrayList<String> command = new ArrayList<String>();
        String scriptPath = this.getAbsolutePath(Paths.get("server", "bin", "start-tc-server"));
        command.add(scriptPath);
        command.add("-f");
        command.add(configFile.toString());
        command.add("-n");
        command.add(this.getServerName());
        command.add("--auto-activate");
        try {
            configDir = Files.createTempDirectory(this.getServerWorkingDir(), "config", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        command.add("-r");
        command.add(configDir.toString());
        this.builtCommand = command.toArray(new String[0]);
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    protected Path convertToConfigFile(boolean properties) {
        Path generatedConfigFileDir = this.getServerWorkingDir().getParent().resolve("generated-configs");
        if (Files.exists(generatedConfigFileDir, new LinkOption[0])) {
            return generatedConfigFileDir;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add("convert");
        command.add("-c");
        command.add(this.getServerWorkingDir().resolve(this.getTcConfig()).toString());
        for (int i = 0; i < 1; ++i) {
            command.add("-s");
            command.add("stripe[" + i + "]");
        }
        if (properties) {
            command.add("-t");
            command.add("properties");
        }
        command.add("-d");
        command.add(generatedConfigFileDir.toString());
        command.add("-f");
        command.add("-n");
        command.add(this.getClusterName());
        ConfigFileStartupBuilder.executeCommand(command);
        return generatedConfigFileDir;
    }

    protected static void executeCommand(List<String> command) {
        new ConfigConverterTool().run(command.toArray(new String[command.size()]));
    }
}

