/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.testing.config;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import org.terracotta.testing.config.StartupCommandBuilder;
import org.terracotta.testing.demos.TestHelpers;

public abstract class AbstractStartupCommandBuilder
implements StartupCommandBuilder {
    private Path kitDir;
    private Path serverWorkingDir;
    private String logConfigExt;
    private String serverName;
    private boolean consistentStartup;
    private Path tcConfig;
    private final int debugPort = Integer.getInteger("configDebugPort", 0);
    private int port;
    private int stripeId;
    private String clusterName = "tc-cluster";
    private Path licensePath;

    public StartupCommandBuilder port(int port) {
        this.port = port;
        return this;
    }

    public StartupCommandBuilder serverWorkingDir(Path serverWorkingDir) {
        this.serverWorkingDir = serverWorkingDir;
        return this;
    }

    public StartupCommandBuilder serverName(String serverName) {
        this.serverName = serverName;
        return this;
    }

    public StartupCommandBuilder consistentStartup(boolean consistentStartup) {
        this.consistentStartup = consistentStartup;
        return this;
    }

    public StartupCommandBuilder kitDir(Path kitDir) {
        this.kitDir = kitDir;
        return this;
    }

    public StartupCommandBuilder logConfigExtension(String logConfigExt) {
        this.logConfigExt = logConfigExt;
        return this;
    }

    public StartupCommandBuilder tcConfig(Path tcConfig) {
        this.tcConfig = tcConfig;
        return this;
    }

    public StartupCommandBuilder clusterName(String clusterName) {
        this.clusterName = clusterName;
        return this;
    }

    public StartupCommandBuilder license(Path licensePath) {
        this.licensePath = licensePath;
        return this;
    }

    public StartupCommandBuilder stripeName(String stripeName) {
        this.stripeId = Integer.parseInt(stripeName.substring(6));
        return this;
    }

    protected void installServer() throws IOException {
        InputStream logExt;
        Files.createDirectories(this.serverWorkingDir, new FileAttribute[0]);
        Files.copy(this.getClass().getResourceAsStream("/tc-logback.xml"), this.serverWorkingDir.resolve("logback-test.xml"), StandardCopyOption.REPLACE_EXISTING);
        Properties props = new Properties();
        props.setProperty("serverWorkingDir", this.serverWorkingDir.toAbsolutePath().toString());
        try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(this.serverWorkingDir.resolve("logbackVars.properties").toFile()), StandardCharsets.UTF_8);){
            props.store(w, "logging variables");
        }
        if (this.logConfigExt != null && (logExt = this.getClass().getResourceAsStream("/" + this.logConfigExt)) != null) {
            Files.copy(logExt, this.serverWorkingDir.resolve("logback-ext-test.xml"), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    protected String getAbsolutePath(Path scriptPath) {
        Path basePath = this.serverWorkingDir.resolve(this.kitDir).resolve(scriptPath).toAbsolutePath().normalize();
        return TestHelpers.isWindows() ? "\"" + basePath + ".bat\"" : basePath + ".sh";
    }

    public abstract String[] build();

    public Path getKitDir() {
        return this.kitDir;
    }

    public Path getServerWorkingDir() {
        return this.serverWorkingDir;
    }

    public String getLogConfigExt() {
        return this.logConfigExt;
    }

    public String getServerName() {
        return this.serverName;
    }

    public boolean isConsistentStartup() {
        return this.consistentStartup;
    }

    public Path getTcConfig() {
        return this.tcConfig;
    }

    public int getDebugPort() {
        return this.debugPort;
    }

    public int getPort() {
        return this.port;
    }

    public int getStripeId() {
        return this.stripeId;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public Path getLicensePath() {
        return this.licensePath;
    }
}

