/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.entity;

import com.tc.classloader.BuiltinService;
import com.tc.classloader.OverrideService;
import com.tc.classloader.OverrideServiceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.terracotta.entity.ActiveServerEntity;
import org.terracotta.entity.ClientCommunicator;
import org.terracotta.entity.ClientDescriptor;
import org.terracotta.entity.ClientSourceId;
import org.terracotta.entity.ConcurrencyStrategy;
import org.terracotta.entity.ConfigurationException;
import org.terracotta.entity.EndpointDelegate;
import org.terracotta.entity.EntityClientEndpoint;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.EntityServerService;
import org.terracotta.entity.ImmediateInvokeFuture;
import org.terracotta.entity.InvocationBuilder;
import org.terracotta.entity.InvokeFuture;
import org.terracotta.entity.InvokeMonitor;
import org.terracotta.entity.MessageCodec;
import org.terracotta.entity.MessageCodecException;
import org.terracotta.entity.PassThroughEntityActiveInvokeContext;
import org.terracotta.entity.PassiveServerEntity;
import org.terracotta.entity.PlatformConfiguration;
import org.terracotta.entity.ServiceConfiguration;
import org.terracotta.entity.ServiceException;
import org.terracotta.entity.ServiceProvider;
import org.terracotta.entity.ServiceProviderCleanupException;
import org.terracotta.entity.ServiceProviderConfiguration;
import org.terracotta.entity.ServiceRegistry;
import org.terracotta.entity.TxIdAwareClientEndpoint;
import org.terracotta.exception.EntityException;
import org.terracotta.exception.EntityServerException;

public class PassthroughStripe<M extends EntityMessage, R extends EntityResponse>
implements ClientCommunicator {
    private final EntityServerService<M, R> service;
    private final FakeServiceRegistry serviceRegistry = new FakeServiceRegistry();
    private final Map<String, ActiveServerEntity<M, R>> activeMap = new HashMap<String, ActiveServerEntity<M, R>>();
    private final Map<String, PassiveServerEntity<M, R>> passiveMap = new HashMap<String, PassiveServerEntity<M, R>>();
    private final Map<String, MessageCodec<M, R>> codecs = new HashMap<String, MessageCodec<M, R>>();
    private final Map<String, byte[]> configMap = new HashMap<String, byte[]>();
    private final Map<String, Integer> connectCountMap = new HashMap<String, Integer>();
    private final Map<String, ConcurrencyStrategy<M>> concurrencyMap = new HashMap<String, ConcurrencyStrategy<M>>();
    private final Map<ClientDescriptor, FakeEndpoint> endpoints = new HashMap<ClientDescriptor, FakeEndpoint>();
    private int nextClientID = 1;
    private int consumerID = 1;
    private AtomicLong txIdGenerator = new AtomicLong(0L);
    private long eldestTxid = -1L;
    private InvokeMonitor<R> monitor;

    public PassthroughStripe(EntityServerService<M, R> service, Class<?> clazz) {
        Assert.assertTrue((boolean)service.handlesEntityType(clazz.getName()));
        this.service = service;
    }

    public boolean createServerEntity(String name, byte[] configuration) throws ConfigurationException {
        boolean didCreate = false;
        if (!this.activeMap.containsKey(name)) {
            MessageCodec codec = this.service.getMessageCodec();
            ActiveServerEntity active = this.service.createActiveEntity(this.serviceRegistry.create(this.consumerID++), configuration);
            PassiveServerEntity passive = this.service.createPassiveEntity(this.serviceRegistry.create(this.consumerID++), configuration);
            ConcurrencyStrategy concurrencyStrategy = this.service.getConcurrencyStrategy(configuration);
            active.createNew();
            passive.createNew();
            this.activeMap.put(name, active);
            this.passiveMap.put(name, passive);
            this.concurrencyMap.put(name, concurrencyStrategy);
            this.codecs.put(name, codec);
            this.configMap.put(name, configuration);
            this.connectCountMap.put(name, 0);
            didCreate = true;
        }
        return didCreate;
    }

    public EntityClientEndpoint<M, R> connectNewClientToEntity(String name) {
        FakeEndpoint endpoint = null;
        if (this.activeMap.containsKey(name)) {
            FakeClientDescriptor descriptor = new FakeClientDescriptor(this.nextClientID);
            MessageCodec<M, R> codec = this.codecs.get(name);
            endpoint = this.getEndpoint(name, descriptor, codec);
            this.endpoints.put(descriptor, endpoint);
            ++this.nextClientID;
            this.connectCountMap.put(name, this.connectCountMap.get(name) + 1);
        }
        return endpoint;
    }

    private FakeEndpoint getEndpoint(String name, ClientDescriptor descriptor, MessageCodec<M, R> codec) {
        return new FakeEndpoint(name, descriptor, codec);
    }

    public void sendNoResponse(ClientDescriptor clientDescriptor, EntityResponse message) {
        FakeEndpoint endpoint = this.endpoints.get(clientDescriptor);
        byte[] payload = endpoint.serializeResponse(message);
        try {
            endpoint.sendNoResponse(payload);
        }
        catch (MessageCodecException e) {
            Assert.fail((String)e.getLocalizedMessage());
        }
    }

    public void closeClientConnection(ClientDescriptor clientDescriptor) {
        this.endpoints.get(clientDescriptor).close();
    }

    private class StripeInvocationBuilder
    implements InvocationBuilder<M, R> {
        private final ClientDescriptor clientDescriptor;
        private final ActiveServerEntity<M, R> activeServerEntity;
        private final MessageCodec<M, R> codec;
        private final PassiveServerEntity<M, R> passiveServerEntity;
        private final long eldestid;
        private final long currentId;
        private final ConcurrencyStrategy<M> concurrency;
        private M request = null;
        private InvokeMonitor<R> monitor;

        public StripeInvocationBuilder(ClientDescriptor clientDescriptor, long currentId, long eldestid, ActiveServerEntity<M, R> activeServerEntity, PassiveServerEntity<M, R> passiveServerEntity, MessageCodec<M, R> codec, ConcurrencyStrategy<M> concurrency) {
            this.clientDescriptor = clientDescriptor;
            this.currentId = currentId;
            this.eldestid = eldestid;
            this.concurrency = concurrency;
            this.activeServerEntity = activeServerEntity;
            this.passiveServerEntity = passiveServerEntity;
            this.codec = codec;
        }

        public InvocationBuilder<M, R> ackSent() {
            return this;
        }

        public InvocationBuilder<M, R> ackReceived() {
            return this;
        }

        public InvocationBuilder<M, R> ackCompleted() {
            return this;
        }

        public InvocationBuilder<M, R> ackRetired() {
            return this;
        }

        public InvocationBuilder<M, R> replicate(boolean requiresReplication) {
            return this;
        }

        public InvocationBuilder<M, R> message(M message) {
            this.request = message;
            return this;
        }

        public InvocationBuilder<M, R> blockGetOnRetire(boolean shouldBlock) {
            return this;
        }

        public InvocationBuilder<M, R> monitor(InvokeMonitor<R> consumer) {
            this.monitor = consumer;
            return this;
        }

        public InvokeFuture<R> invoke() throws MessageCodecException {
            byte[] result = null;
            EntityException error = null;
            try {
                result = this.sendInvocation(this.currentId, this.eldestid, this.activeServerEntity, this.codec);
            }
            catch (EntityException e) {
                error = e;
            }
            this.monitor = null;
            return new ImmediateInvokeFuture<EntityResponse>(this.codec.decodeResponse(result), error);
        }

        public InvokeFuture<R> invokeWithTimeout(long time, TimeUnit units) throws InterruptedException, TimeoutException, MessageCodecException {
            return this.invoke();
        }

        public InvocationBuilder<M, R> withExecutor(Executor exctr) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Deprecated
        public InvocationBuilder<M, R> asDeferredResponse() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        private byte[] sendInvocation(long currentId, long eldestId, ActiveServerEntity<M, R> entity, MessageCodec<M, R> codec) throws EntityException {
            byte[] result = null;
            int requestConcurrencyKey = this.concurrency.concurrencyKey(this.request);
            try {
                EntityResponse response = entity.invokeActive(new PassThroughEntityActiveInvokeContext(this.clientDescriptor, requestConcurrencyKey, currentId, eldestId, this.monitor), this.request);
                result = codec.encodeResponse(response);
            }
            catch (Exception e) {
                throw new EntityServerException(null, null, null, (Throwable)e);
            }
            return result;
        }
    }

    private class FakeClientDescriptor
    implements ClientDescriptor {
        private final int id;

        public FakeClientDescriptor(int id) {
            this.id = id;
        }

        public int hashCode() {
            return this.id;
        }

        public boolean equals(Object obj) {
            return ((FakeClientDescriptor)obj).id == this.id;
        }

        public ClientSourceId getSourceId() {
            return null;
        }

        public boolean isValidClient() {
            return false;
        }
    }

    private class FakeEndpoint
    implements TxIdAwareClientEndpoint<M, R> {
        private EndpointDelegate delegate;
        private final String entityName;
        private final ClientDescriptor clientDescriptor;
        private final MessageCodec<M, R> codec;
        private AtomicLong currentId = new AtomicLong(0L);
        private volatile long eldestid = -1L;

        public FakeEndpoint(String name, ClientDescriptor clientDescriptor, MessageCodec<M, R> codec) {
            this.entityName = name;
            this.clientDescriptor = clientDescriptor;
            this.codec = codec;
        }

        public byte[] serializeResponse(EntityResponse r) {
            byte[] raw = null;
            try {
                raw = this.codec.encodeResponse(r);
            }
            catch (MessageCodecException e) {
                Assert.fail();
            }
            return raw;
        }

        public void sendNoResponse(byte[] payload) throws MessageCodecException {
            if (null != this.delegate) {
                EntityResponse fromServer = this.codec.decodeResponse(payload);
                this.delegate.handleMessage(fromServer);
            }
        }

        public byte[] getEntityConfiguration() {
            return (byte[])PassthroughStripe.this.configMap.get(this.entityName);
        }

        public void setDelegate(EndpointDelegate delegate) {
            Assert.assertNull((Object)this.delegate);
            this.delegate = delegate;
        }

        public InvocationBuilder<M, R> beginInvoke() {
            return new StripeInvocationBuilder(this.clientDescriptor, this.currentId.incrementAndGet(), this.eldestid, (ActiveServerEntity)PassthroughStripe.this.activeMap.get(this.entityName), (PassiveServerEntity)PassthroughStripe.this.passiveMap.get(this.entityName), (MessageCodec)PassthroughStripe.this.codecs.get(this.entityName), (ConcurrencyStrategy)PassthroughStripe.this.concurrencyMap.get(this.entityName));
        }

        public void close() {
            PassthroughStripe.this.connectCountMap.put(this.entityName, (Integer)PassthroughStripe.this.connectCountMap.get(this.entityName) - 1);
        }

        public Future<Void> release() {
            this.close();
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public long getCurrentId() {
            return this.currentId.get();
        }

        @Override
        public long resetEldestId() {
            return this.eldestid;
        }
    }

    private class FakeServiceRegistry {
        private final Map<String, ServiceProvider> builtins = new HashMap<String, ServiceProvider>();

        FakeServiceRegistry() {
            ServiceLoader<ServiceProvider> loader = ServiceLoader.load(ServiceProvider.class);
            HashMap overrides = new HashMap();
            for (ServiceProvider provider : loader) {
                Object value;
                Class<?> type = provider.getClass();
                if (type.isAnnotationPresent(OverrideService.class)) {
                    for (OverrideService overrideService : (OverrideService[])type.getAnnotationsByType(OverrideService.class)) {
                        value = overrideService.value();
                        String[] types = overrideService.types();
                        if (value != null && ((String)value).length() > 0) {
                            this.builtins.remove(value);
                            overrides.put(value, type);
                        }
                        for (String typeName : types) {
                            this.builtins.remove(typeName);
                            overrides.put(typeName, type);
                        }
                    }
                }
                if (type.isAnnotationPresent(OverrideServiceType.class)) {
                    for (OverrideService overrideService : (OverrideServiceType[])type.getAnnotationsByType(OverrideServiceType.class)) {
                        value = overrideService.value();
                        if (value == null) continue;
                        this.builtins.remove(((Class)value).getName());
                        overrides.put(((Class)value).getName(), type);
                    }
                }
                if (!provider.getClass().isAnnotationPresent(BuiltinService.class)) {
                    System.err.println("service:" + provider.getClass().getName() + " not annotated with @BuiltinService.  The service will not be included");
                    continue;
                }
                if (overrides.containsKey(type.getName())) continue;
                this.builtins.put(type.getName(), provider);
            }
            final ArrayList<Class<ClientCommunicator>> selfTypes = new ArrayList<Class<ClientCommunicator>>(1);
            selfTypes.add(ClientCommunicator.class);
            this.builtins.put(ClientCommunicator.class.getName(), new ServiceProvider(){

                public boolean initialize(ServiceProviderConfiguration configuration, PlatformConfiguration platformConfiguration) {
                    return true;
                }

                public <T> T getService(long consumerID, ServiceConfiguration<T> configuration) {
                    if (configuration.getServiceType().equals(ClientCommunicator.class)) {
                        return configuration.getServiceType().cast(PassthroughStripe.this);
                    }
                    return null;
                }

                public Collection<Class<?>> getProvidedServiceTypes() {
                    return selfTypes;
                }

                public void prepareForSynchronization() throws ServiceProviderCleanupException {
                }
            });
        }

        public ServiceRegistry create(final long cid) {
            return new ServiceRegistry(){

                public <T> T getService(ServiceConfiguration<T> configuration) throws ServiceException {
                    Object rService = null;
                    for (ServiceProvider provider : FakeServiceRegistry.this.builtins.values()) {
                        Object service;
                        if (!provider.getProvidedServiceTypes().contains(configuration.getServiceType()) || (service = provider.getService(cid, configuration)) == null) continue;
                        if (rService != null) {
                            throw new ServiceException("multiple services defined");
                        }
                        rService = service;
                    }
                    return (T)rService;
                }

                public <T> Collection<T> getServices(ServiceConfiguration<T> configuration) {
                    ArrayList<Object> choices = new ArrayList<Object>();
                    for (ServiceProvider provider : FakeServiceRegistry.this.builtins.values()) {
                        Object service;
                        if (!provider.getProvidedServiceTypes().contains(configuration.getServiceType()) || (service = provider.getService(cid, configuration)) == null) continue;
                        choices.add(service);
                    }
                    return choices;
                }
            };
        }
    }
}

