/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.entity;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.terracotta.entity.ActiveServerEntity;
import org.terracotta.entity.ClientCommunicator;
import org.terracotta.entity.ClientDescriptor;
import org.terracotta.entity.ClientSourceId;
import org.terracotta.entity.ConcurrencyStrategy;
import org.terracotta.entity.EndpointDelegate;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.ImmediateInvokeFuture;
import org.terracotta.entity.InvocationBuilder;
import org.terracotta.entity.InvokeFuture;
import org.terracotta.entity.InvokeMonitor;
import org.terracotta.entity.MessageCodec;
import org.terracotta.entity.MessageCodecException;
import org.terracotta.entity.PassThroughEntityActiveInvokeContext;
import org.terracotta.entity.TxIdAwareClientEndpoint;
import org.terracotta.exception.EntityException;
import org.terracotta.exception.EntityServerException;

public class PassthroughEndpoint<M extends EntityMessage, R extends EntityResponse>
implements TxIdAwareClientEndpoint<M, R> {
    private final ClientDescriptor clientDescriptor = new FakeClientDescriptor();
    private ActiveServerEntity<M, R> entity;
    private MessageCodec<M, R> codec;
    private byte[] configuration;
    private EndpointDelegate delegate;
    private final ClientCommunicator clientCommunicator = new TestClientCommunicator();
    private boolean isOpen = true;
    private AtomicLong idGenerator = new AtomicLong(0L);
    private volatile long eldest = -1L;
    private ConcurrencyStrategy<M> concurrencyStrategy;
    private InvokeMonitor monitor;

    public void attach(ActiveServerEntity<M, R> entity, MessageCodec<M, R> codec, ConcurrencyStrategy<M> concurrencyStrategy, byte[] config) {
        this.entity = entity;
        this.concurrencyStrategy = concurrencyStrategy;
        this.codec = codec;
        this.configuration = config;
        entity.connected(this.clientDescriptor);
    }

    public byte[] getEntityConfiguration() {
        this.checkEndpointOpen();
        return this.configuration;
    }

    public void setDelegate(EndpointDelegate delegate) {
        this.checkEndpointOpen();
        Assert.assertNull((Object)this.delegate);
        this.delegate = delegate;
    }

    public InvocationBuilder<M, R> beginInvoke() {
        this.checkEndpointOpen();
        return new InvocationBuilderImpl();
    }

    public ClientCommunicator clientCommunicator() {
        return this.clientCommunicator;
    }

    public void close() {
        this.checkEndpointOpen();
        this.isOpen = false;
    }

    public Future<Void> release() {
        this.close();
        return CompletableFuture.completedFuture(null);
    }

    private void checkEndpointOpen() {
        if (!this.isOpen) {
            throw new IllegalStateException("Endpoint closed");
        }
    }

    @Override
    public long getCurrentId() {
        return this.idGenerator.get();
    }

    @Override
    public long resetEldestId() {
        this.eldest = this.idGenerator.get();
        return this.eldest;
    }

    private class TestClientCommunicator
    implements ClientCommunicator {
        private TestClientCommunicator() {
        }

        public void sendNoResponse(ClientDescriptor clientDescriptor, EntityResponse message) {
            if (clientDescriptor == PassthroughEndpoint.this.clientDescriptor && null != PassthroughEndpoint.this.delegate) {
                try {
                    byte[] payload = PassthroughEndpoint.this.codec.encodeResponse(message);
                    EntityResponse fromServer = PassthroughEndpoint.this.codec.decodeResponse(payload);
                    PassthroughEndpoint.this.delegate.handleMessage(fromServer);
                }
                catch (MessageCodecException e) {
                    Assert.fail();
                }
            }
        }

        public void closeClientConnection(ClientDescriptor clientDescriptor) {
            PassthroughEndpoint.this.close();
        }
    }

    private class InvocationBuilderImpl
    implements InvocationBuilder<M, R> {
        private M request = null;

        private InvocationBuilderImpl() {
        }

        public InvocationBuilder<M, R> ackSent() {
            return this;
        }

        public InvocationBuilder<M, R> ackReceived() {
            return this;
        }

        public InvocationBuilder<M, R> ackCompleted() {
            return this;
        }

        public InvocationBuilder<M, R> ackRetired() {
            return this;
        }

        public InvocationBuilder<M, R> replicate(boolean requiresReplication) {
            return this;
        }

        public InvocationBuilder<M, R> message(M message) {
            this.request = message;
            return this;
        }

        public InvocationBuilder<M, R> blockGetOnRetire(boolean shouldBlock) {
            return this;
        }

        public InvocationBuilder<M, R> monitor(InvokeMonitor<R> consumer) {
            PassthroughEndpoint.this.monitor = consumer;
            return this;
        }

        public InvocationBuilder<M, R> withExecutor(Executor exctr) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Deprecated
        public InvocationBuilder<M, R> asDeferredResponse() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InvokeFuture<R> invoke() throws MessageCodecException {
            ActiveServerEntity activeServerEntity = PassthroughEndpoint.this.entity;
            synchronized (activeServerEntity) {
                byte[] result = null;
                EntityException error = null;
                try {
                    result = this.sendInvocation(PassthroughEndpoint.this.codec.encodeMessage(this.request), PassthroughEndpoint.this.monitor);
                }
                catch (EntityException ee) {
                    error = ee;
                }
                PassthroughEndpoint.this.monitor = null;
                return new ImmediateInvokeFuture<EntityResponse>(PassthroughEndpoint.this.codec.decodeResponse(result), error);
            }
        }

        public InvokeFuture<R> invokeWithTimeout(long time, TimeUnit units) throws InterruptedException, TimeoutException, MessageCodecException {
            return this.invoke();
        }

        private byte[] sendInvocation(byte[] payload, InvokeMonitor<R> monitor) throws EntityException {
            byte[] result = null;
            try {
                EntityMessage message = PassthroughEndpoint.this.codec.decodeMessage(payload);
                int key = PassthroughEndpoint.this.concurrencyStrategy.concurrencyKey(message);
                EntityResponse response = PassthroughEndpoint.this.entity.invokeActive(new PassThroughEntityActiveInvokeContext(PassthroughEndpoint.this.clientDescriptor, key, PassthroughEndpoint.this.idGenerator.incrementAndGet(), PassthroughEndpoint.this.eldest, monitor), message);
                result = PassthroughEndpoint.this.codec.encodeResponse(response);
            }
            catch (Exception e) {
                throw new EntityServerException(null, null, null, (Throwable)e);
            }
            return result;
        }
    }

    private class FakeClientDescriptor
    implements ClientDescriptor {
        private FakeClientDescriptor() {
        }

        public ClientSourceId getSourceId() {
            return null;
        }

        public boolean isValidClient() {
            return false;
        }
    }
}

