/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.entity;

import org.terracotta.entity.ActiveInvokeChannel;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.InvokeMonitor;
import org.terracotta.exception.EntityException;
import org.terracotta.exception.EntityServerException;

public class PassThroughEntityActiveInvokeChannel<R extends EntityResponse>
implements ActiveInvokeChannel<R> {
    private final InvokeMonitor<R> monitor;
    private volatile boolean closed = false;

    public PassThroughEntityActiveInvokeChannel(InvokeMonitor<R> monitor) {
        this.monitor = monitor;
    }

    public synchronized void sendResponse(R r) {
        this.checkClosed();
        this.monitor.accept(r);
    }

    public synchronized void sendException(Exception ee) {
        this.checkClosed();
        if (ee instanceof EntityException) {
            this.monitor.exception((EntityException)((Object)ee));
        } else {
            this.monitor.exception((EntityException)new EntityServerException(null, null, null, (Throwable)ee));
        }
    }

    public synchronized void close() {
        if (this.attemptClose()) {
            this.monitor.close();
        }
    }

    private synchronized boolean attemptClose() {
        try {
            boolean bl = !this.closed;
            return bl;
        }
        finally {
            this.closed = true;
        }
    }

    private synchronized void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("channel closed");
        }
    }
}

