/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.license.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import org.terracotta.license.util.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static byte[] toBytes(Properties props, List<String> ignoredKeys, String encoding) throws UnsupportedEncodingException {
        TreeSet<Object> keys = new TreeSet<Object>(props.keySet());
        keys.removeAll(ignoredKeys);
        StringBuilder sb = new StringBuilder();
        for (String string : keys) {
            sb.append(string).append(props.getProperty(string));
        }
        return sb.toString().getBytes(encoding);
    }

    public static byte[] toBytes(List<String> lines, String encoding) throws UnsupportedEncodingException {
        int licenseVersion = 1;
        ArrayList<String> filteredLines = new ArrayList();
        for (String line : lines) {
            if (!line.contains("Descriptor version")) continue;
            licenseVersion = 2;
        }
        filteredLines = Utils.filterNoneLicenseInfo(lines);
        String rawLicenseAsString = Utils.join(filteredLines, "");
        if (licenseVersion == 1) {
            rawLicenseAsString = rawLicenseAsString.replace(" = ", "");
        }
        return rawLicenseAsString.getBytes(encoding);
    }

    public static String join(Collection<String> list, String separator) {
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            sb.append(s).append(separator);
        }
        if (sb.toString().endsWith(separator)) {
            sb.delete(sb.length() - separator.length(), sb.length());
        }
        return sb.toString();
    }

    public static Properties loadProperties(List<String> lines) {
        Properties props = new Properties();
        for (String line : lines) {
            if (line.startsWith("#") || line.startsWith("!") || line.length() == 0) continue;
            String[] tokens = line.split("[:=]", 2);
            if (tokens.length != 2) {
                throw new RuntimeException("Properties files syntax error. Can't parse: '" + line + "'");
            }
            props.setProperty(tokens[0].trim(), tokens[1].trim());
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readLines(InputStream in) throws IOException {
        ArrayList<String> arrayList;
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                lines.add(line);
            }
            arrayList = lines;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly(reader);
        return arrayList;
    }

    public static List<String> filterNoneLicenseInfo(List<String> lines) {
        int index1 = lines.indexOf("--------------------- BEGIN TERRACOTTA LICENSE KEY ---------------------");
        int index2 = lines.indexOf("---------------------------- BEGIN SIGNATURE ---------------------------");
        if (index1 == -1 || index2 == -1) {
            return lines;
        }
        return lines.subList(index1 + 1, index2);
    }
}

