/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.license.constraints;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.terracotta.license.License;
import org.terracotta.license.LicenseException;
import org.terracotta.license.constraints.FieldAndCapabitlityConstraint;
import org.terracotta.license.constraints.LicenseConstraint;
import org.terracotta.license.constraints.RequiredFieldConstraint;
import org.terracotta.license.util.MemorySizeParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LicenseContraintsFactory {
    private static final long MIN_OFFHEAP_SIZE_BYTES = 0x8000000L;
    private static final long MIN_OFFHEAP_SIZE_MEGABYTES = 128L;

    public static List<LicenseConstraint> getAllContraints(License license) {
        ArrayList<LicenseConstraint> contraints = new ArrayList<LicenseConstraint>();
        contraints.add(new RequiredFieldConstraint(license.getProperties()));
        contraints.add(new EhcacheOffheapConstraint(license));
        contraints.add(new ServerArrayOffheapConstraint(license));
        List<String> terracottaCapabilities = Arrays.asList("authentication", "DCV2", "operator console", "roots", "server striping", "sessions");
        contraints.add(new TerracottaAndClientCountContraint(license, terracottaCapabilities));
        return contraints;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TerracottaAndClientCountContraint
    implements LicenseConstraint {
        private final License license;
        private final List<String> terracottaCapabilities;

        public TerracottaAndClientCountContraint(License license, List<String> terracottaCapabilities) {
            this.license = license;
            this.terracottaCapabilities = terracottaCapabilities;
        }

        @Override
        public void verify() {
            boolean tcEnabled = false;
            String terracottaCapability = null;
            Set<String> currentCapabilities = this.license.capabilities();
            for (String capability : this.terracottaCapabilities) {
                if (!currentCapabilities.contains(capability)) continue;
                tcEnabled = true;
                terracottaCapability = capability;
            }
            int maxClientCount = this.license.maxClientCount();
            if (tcEnabled && maxClientCount <= 0) {
                throw new LicenseException("Terracotta capability '" + terracottaCapability + "' is enabled therefore \nfield '" + "Max Client Count" + "' must have non-zero value");
            }
        }
    }

    static class ServerArrayOffheapConstraint
    extends FieldAndCapabitlityConstraint {
        public ServerArrayOffheapConstraint(License license) {
            super(license, "terracotta.serverArray.maxOffHeap", "server array offheap");
        }

        public void verifyFieldValue(String value) {
            if (value == null || MemorySizeParser.parse(value) < 0x8000000L) {
                throw new LicenseException("Capability 'server array offheap' is enabled therefore value of 'terracotta.serverArray.maxOffHeap'\n must be at least 128 MB");
            }
        }
    }

    static class EhcacheOffheapConstraint
    extends FieldAndCapabitlityConstraint {
        public EhcacheOffheapConstraint(License license) {
            super(license, "ehcache.maxOffHeap", "ehcache offheap");
        }

        public void verifyFieldValue(String value) {
            if (value == null || MemorySizeParser.parse(value) < 0x8000000L) {
                throw new LicenseException("Capability 'ehcache offheap' is enabled therefore value of 'ehcache.maxOffHeap'\n must be at least 128 MB");
            }
        }
    }
}

