/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.license;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.terracotta.license.EnterpriseLicense;
import org.terracotta.license.EnterpriseLicenseResolverFactory;
import org.terracotta.license.License;
import org.terracotta.license.LicenseConstants;
import org.terracotta.license.LicenseException;
import org.terracotta.license.LicenseSigner;
import org.terracotta.license.constraints.LicenseConstraint;
import org.terracotta.license.constraints.LicenseContraintsFactory;
import org.terracotta.license.util.IOUtils;
import org.terracotta.license.util.MemorySizeParser;
import org.terracotta.license.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LicenseBuilder {
    private final Properties properties = new Properties();
    private File privateKeyFile;

    public LicenseBuilder setProduct(String product) {
        this.properties.setProperty("Product", product);
        return this;
    }

    public LicenseBuilder setEdition(String edition) {
        this.properties.setProperty("Edition", edition);
        return this;
    }

    public LicenseBuilder setLicenseType(String type) {
        this.properties.setProperty("License Type", type);
        return this;
    }

    public LicenseBuilder setLicenseNumber(String number) {
        this.properties.setProperty("License Number", number);
        return this;
    }

    public LicenseBuilder setLicensee(String licensee) {
        this.properties.setProperty("Licensee", licensee);
        return this;
    }

    public LicenseBuilder setCapabilities(String commaSeparatedCabapilities) {
        this.properties.setProperty("Capabilities", commaSeparatedCabapilities);
        return this;
    }

    public LicenseBuilder setCapabilities(Collection<String> capabilities) {
        this.properties.setProperty("Capabilities", Utils.join(capabilities, ", "));
        return this;
    }

    public LicenseBuilder setEhcacheMaxOffheap(String maxSize) {
        MemorySizeParser.parse(maxSize);
        this.properties.setProperty("ehcache.maxOffHeap", maxSize);
        return this;
    }

    public LicenseBuilder setTerracottaServerArrayMaxOffheap(String maxSize) {
        MemorySizeParser.parse(maxSize);
        this.properties.setProperty("terracotta.serverArray.maxOffHeap", maxSize);
        return this;
    }

    public LicenseBuilder setTerracottaClientMaxOffheap(String maxSize) {
        MemorySizeParser.parse(maxSize);
        this.properties.setProperty("terracotta.client.maxOffHeap", maxSize);
        return this;
    }

    public LicenseBuilder setMaxClientCount(int maxClientCount) {
        this.properties.setProperty("Max Client Count", String.valueOf(maxClientCount));
        return this;
    }

    public LicenseBuilder setExpirationDate(String date) {
        try {
            LicenseConstants.dateFormatter().parse(date);
        }
        catch (ParseException e) {
            throw new LicenseException("Date format should be: " + "yyyy-MM-dd".toUpperCase());
        }
        this.properties.setProperty("Expiration Date", date);
        return this;
    }

    public void setPrivateKey(String privateKeyFile) {
        this.privateKeyFile = new File(privateKeyFile);
    }

    public void setLicenseProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public License createUnsignedLicense() {
        this.properties.setProperty("Date of Issue", LicenseConstants.dateFormatter().format(new Date()));
        this.properties.setProperty("Signature", "unsigned");
        EnterpriseLicense license = new EnterpriseLicense(this.properties);
        this.validateConstraints(license);
        return license;
    }

    public License createLicense() {
        if (this.privateKeyFile == null || !this.privateKeyFile.exists()) {
            throw new IllegalStateException("Need private key file to sign license");
        }
        this.properties.setProperty("Date of Issue", LicenseConstants.dateFormatter().format(new Date()));
        try {
            byte[] licenseBytes = Utils.toBytes(this.properties, LicenseConstants.IGNORED_KEYS, "UTF-8");
            String signature = new LicenseSigner().sign(licenseBytes, this.privateKeyFile);
            this.properties.setProperty("Signature", signature);
        }
        catch (UnsupportedEncodingException e) {
            throw new LicenseException(e);
        }
        EnterpriseLicense license = new EnterpriseLicense(this.properties);
        this.validateConstraints(license);
        this.validateSignature(license);
        return license;
    }

    private void validateSignature(License license) {
        FileInputStream in = null;
        try {
            File tempFile = File.createTempFile("tc-license", ".tmp");
            tempFile.deleteOnExit();
            license.toFile(tempFile.getAbsolutePath());
            in = new FileInputStream(tempFile);
            new EnterpriseLicenseResolverFactory().resolveLicense(in);
        }
        catch (IOException e) {
            try {
                throw new LicenseException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(in);
    }

    private void validateConstraints(License license) {
        for (LicenseConstraint constraint : LicenseContraintsFactory.getAllContraints(license)) {
            constraint.verify();
        }
    }

    public static void buildDevLicense(String privateKeyPath, String saveToFile) {
        LicenseBuilder builder = new LicenseBuilder();
        builder.setProduct("Enterprise Suite");
        builder.setEdition("FX");
        List<String> capabilities = Arrays.asList("roots", "sessions", "authentication", "DCV2", "server striping", "operator console", "server array offheap", "ehcache monitor", "ehcache offheap", "ehcache", "quartz");
        builder.setCapabilities(capabilities);
        builder.setLicensee("Terracotta QA");
        builder.setLicenseNumber("01");
        builder.setLicenseType("Trial");
        builder.setMaxClientCount(200);
        builder.setEhcacheMaxOffheap("64g");
        builder.setTerracottaServerArrayMaxOffheap("64g");
        builder.setPrivateKey(privateKeyPath);
        License license = builder.createLicense();
        license.toFile(saveToFile);
        System.out.println(license.toString());
    }

    public static void buildBetaLicense(String privateKeyPath, String saveToFile) {
        LicenseBuilder builder = new LicenseBuilder();
        builder.setProduct("Enterprise Suite");
        builder.setEdition("FX");
        List<String> capabilities = Arrays.asList("roots", "sessions", "authentication", "DCV2", "server striping", "operator console", "server array offheap", "ehcache monitor", "ehcache offheap", "ehcache", "quartz");
        builder.setCapabilities(capabilities);
        builder.setLicensee("BETA TESTERS");
        builder.setLicenseNumber("BETA-01");
        builder.setLicenseType("Trial");
        builder.setExpirationDate("2010-10-25");
        builder.setMaxClientCount(4);
        builder.setEhcacheMaxOffheap("64g");
        builder.setTerracottaServerArrayMaxOffheap("64g");
        builder.setPrivateKey(privateKeyPath);
        License license = builder.createLicense();
        license.toFile(saveToFile);
        System.out.println(license.toString());
    }

    public static void buildTestLicense(String privateKeyPath, String saveToFile) {
        LicenseBuilder builder = new LicenseBuilder();
        builder.setProduct("Enterprise Suite");
        builder.setEdition("DX");
        List<String> capabilities = Arrays.asList("ehcache monitor");
        builder.setCapabilities(capabilities);
        builder.setLicensee("Terracotta QA");
        builder.setLicenseNumber("01");
        builder.setLicenseType("Commercial");
        builder.setPrivateKey(privateKeyPath);
        License license = builder.createLicense();
        license.toFile(saveToFile);
        System.out.println(license.toString());
    }

    public static void main(String[] args) {
        String privateKeyPath = "C:\\cygwin\\home\\hhuynh\\license-private-key.pkcs8";
        LicenseBuilder.buildDevLicense(privateKeyPath, "c:\\dev\\dev-terracotta-license.key");
        LicenseBuilder.buildBetaLicense(privateKeyPath, "c:\\dev\\beta-terracotta-license.key");
        LicenseBuilder.buildTestLicense(privateKeyPath, "c:\\dev\\test-terracotta-license.key");
    }
}

