/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.license;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.terracotta.license.License;
import org.terracotta.license.LicenseConstants;
import org.terracotta.license.LicenseException;
import org.terracotta.license.util.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLicense
implements License {
    protected final Properties properties;
    protected final Set<String> capabilities;

    public AbstractLicense(Properties properties) {
        this.properties = properties;
        String[] tokens = this.getRequiredProperty("Capabilities").split("\\s*,\\s*");
        this.capabilities = new TreeSet<String>(Arrays.asList(tokens));
    }

    @Override
    public String product() {
        return this.getRequiredProperty("Product");
    }

    @Override
    public String edition() {
        return this.getRequiredProperty("Edition");
    }

    @Override
    public String type() {
        return this.getRequiredProperty("License Type");
    }

    @Override
    public String licensee() {
        return this.getRequiredProperty("Licensee");
    }

    @Override
    public String number() {
        return this.getRequiredProperty("License Number");
    }

    @Override
    public Set<String> capabilities() {
        return this.capabilities;
    }

    @Override
    public Date expirationDate() {
        String dateValue = this.properties.getProperty("Expiration Date");
        if (dateValue == null) {
            return null;
        }
        try {
            return LicenseConstants.dateFormatter().parse(dateValue);
        }
        catch (ParseException e) {
            throw new LicenseException("Date format should be: " + "yyyy-MM-dd".toUpperCase() + ". Date value was " + dateValue);
        }
    }

    @Override
    public boolean isExpired() {
        return this.expirationDate() != null && new Date().after(this.expirationDate());
    }

    @Override
    public String signature() {
        return this.getRequiredProperty("Signature");
    }

    @Override
    public int maxClientCount() {
        String maxCount = this.properties.getProperty("terracotta.maxClientCount");
        if (maxCount == null) {
            maxCount = this.properties.getProperty("Max Client Count");
        }
        return maxCount == null ? -1 : Integer.valueOf(maxCount);
    }

    @Override
    public String getRequiredProperty(String key) {
        String value = this.properties.getProperty(key);
        if (value == null || value.trim().length() == 0) {
            throw new LicenseException("License key invalid. Required field '" + key + "' is missing");
        }
        return value.trim();
    }

    @Override
    public String getProperty(String key) {
        String value = this.properties.getProperty(key);
        return value != null ? value.trim() : null;
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public boolean isCapabilityEnabled(String capability) {
        return this.capabilities.contains(capability);
    }

    @Override
    public void toFile(String file) {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileOutputStream(file));
            writer.println("# This software license, granted by Terracotta Inc., is valid for and may only be used");
            writer.println("# by the licensee of this product (\"Licensee\").");
            writer.println("# Descriptor version: 3");
            writer.println("# ------------------------------------------------------------------------------------");
            writer.println(this.toString());
            writer.println("Signature: " + this.signature());
        }
        catch (IOException e) {
            try {
                throw new LicenseException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(writer);
    }
}

