/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.org.mortbay.jetty.security;

import java.security.MessageDigest;
import org.terracotta.ehcachedx.org.mortbay.jetty.security.Password;
import org.terracotta.ehcachedx.org.mortbay.jetty.security.UnixCrypt;
import org.terracotta.ehcachedx.org.mortbay.log.Log;
import org.terracotta.ehcachedx.org.mortbay.util.StringUtil;
import org.terracotta.ehcachedx.org.mortbay.util.TypeUtil;

public abstract class Credential {
    public abstract boolean check(Object var1);

    public static Credential getCredential(String credential) {
        if (credential.startsWith("CRYPT:")) {
            return new Crypt(credential);
        }
        if (credential.startsWith("MD5:")) {
            return new MD5(credential);
        }
        return new Password(credential);
    }

    public static class MD5
    extends Credential {
        public static final String __TYPE = "MD5:";
        public static final Object __md5Lock = new Object();
        private static MessageDigest __md;
        private final byte[] _digest;

        MD5(String digest) {
            digest = digest.startsWith(__TYPE) ? digest.substring(__TYPE.length()) : digest;
            this._digest = TypeUtil.parseBytes(digest, 16);
        }

        public byte[] getDigest() {
            return this._digest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean check(Object credentials) {
            try {
                byte[] digest = null;
                if (credentials instanceof Password || credentials instanceof String) {
                    Object object = __md5Lock;
                    synchronized (object) {
                        if (__md == null) {
                            __md = MessageDigest.getInstance("MD5");
                        }
                        __md.reset();
                        __md.update(credentials.toString().getBytes(StringUtil.__ISO_8859_1));
                        digest = __md.digest();
                    }
                    if (digest == null || digest.length != this._digest.length) {
                        return false;
                    }
                    for (int i = 0; i < digest.length; ++i) {
                        if (digest[i] == this._digest[i]) continue;
                        return false;
                    }
                    return true;
                }
                if (credentials instanceof MD5) {
                    MD5 md5 = (MD5)credentials;
                    if (this._digest.length != md5._digest.length) {
                        return false;
                    }
                    for (int i = 0; i < this._digest.length; ++i) {
                        if (this._digest[i] == md5._digest[i]) continue;
                        return false;
                    }
                    return true;
                }
                if (credentials instanceof Credential) {
                    return ((Credential)credentials).check(this);
                }
                Log.warn("Can't check " + credentials.getClass() + " against MD5");
                return false;
            }
            catch (Exception e) {
                Log.warn(e);
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String digest(String password) {
            try {
                byte[] digest;
                Object object = __md5Lock;
                synchronized (object) {
                    if (__md == null) {
                        try {
                            __md = MessageDigest.getInstance("MD5");
                        }
                        catch (Exception e) {
                            Log.warn(e);
                            return null;
                        }
                    }
                    __md.reset();
                    __md.update(password.getBytes(StringUtil.__ISO_8859_1));
                    digest = __md.digest();
                }
                return __TYPE + TypeUtil.toString(digest, 16);
            }
            catch (Exception e) {
                Log.warn(e);
                return null;
            }
        }
    }

    public static class Crypt
    extends Credential {
        public static final String __TYPE = "CRYPT:";
        private final String _cooked;

        Crypt(String cooked) {
            this._cooked = cooked.startsWith(__TYPE) ? cooked.substring(__TYPE.length()) : cooked;
        }

        public boolean check(Object credentials) {
            if (!(credentials instanceof String) && !(credentials instanceof Password)) {
                Log.warn("Can't check " + credentials.getClass() + " against CRYPT");
            }
            String passwd = credentials.toString();
            return this._cooked.equals(UnixCrypt.crypt(passwd, this._cooked));
        }

        public static String crypt(String user, String pw) {
            return __TYPE + UnixCrypt.crypt(pw, user);
        }
    }
}

